<?php

class jp_ProtectByMD5 extends plugin {
	static public function name(){
		return 'ProtectByMD5';
	}
	static public function author(){
		return 'Katsumi';
	}
	static public function url(){
		return 'http://jeanscms.sourceforge.jp/';
	}
	static public function desc(){
		return '_JP_PROTECTBYMD5_DESC';
	}
	static public function version(){
		return '0.1.1';
	}
	static public function install(){
		self::option()->create('usethis','_JP_PROTECTBYMD5_ENABLE_THIS','yesno',1);
		self::option()->create('log','_JP_PROTECTBYMD5_LOG','yesno',1);
		self::option()->create('actions','_JP_PROTECTBYMD5_ACTIONS','textarea','admin.comment.add');
		self::option()->create('jsencode','_JP_PROTECTBYMD5_JSENCODE','yesno',0);
		self::option()->create('errormessage','_JP_PROTECTBYMD5_ERRORMESSAGE','textarea',self::translate('_JP_PROTECTBYMD5_ERRORMESSAGE_DEFAULT'));
		self::option()->create('acceptlist','_JP_PROTECTBYMD5_ACCEPTLIST','yesno',0);
	}
	static private $i=0;
	static public function events(){
		return array('form_extra','pre_action');
	}
	static $ob=false,$tag=false;
	/*
	 * <%js.protectbymd5.begin%>
	 * This tag can be omitted when not using jsencode mode.
	 */
	static public function tag_begin(){
		if (!self::option()->usethis) return;
		if (!self::option()->jsencode) return;
		self::$ob=ob_start();
		self::$i++;
	}
	/*
	 * <%js.protectbymd5.tag%>
	 * This tag can be omitted when using for comment, private-message, etc that support even_form_extra.
	 */
	static public function tag_tag(&$data){
		if (!self::option()->usethis) return;
		if (!self::$ob) self::$i++;
		self::show_tag($data['libs']['ticket']['ticket']);
		if (!self::$ob) self::calc_hash();
		else self::$tag=true;
	}
	static public function event_form_extra(&$array){
		self::tag_tag($array['data']);
	}
	/*
	 * <%js.protectbymd5.end%>
	 * This tag can be omitted when not using jsencode mode.
	 */
	static public function tag_end(&$data){
		if (!self::$ob) return
		self::$ob=false;
		$html=ob_get_clean();
		self::echo_html('<span id="<%0%>"><span style="display:none">','jp_protectbymd5_span'.self::$i);
		self::p(preg_replace_callback('/[\x20-\x7f]/',array('self','cb_tag_end'),$html));
		self::echo_html('</span></span>');
		self::jsdecode();
		if (self::$tag) self::calc_hash();
		self::$tag=false;
	}
	static private function cb_tag_end($m){
		return '%'.dechex(ord($m[0]));
	}
	static private function show_tag($ticket){
		self::echo_html(
			'<input type="hidden" name="jp_protectbymd5_hash" value="<%value%>" id="<%id%>" />'."\n",
			array('value'=>$ticket,'id'=>'jp_protectbymd5_hash'.self::$i));
	}
	static private function calc_hash(){
		self::javascript();
		$script='<script type="text/javascript">js_protectbymd5_calc_hash("<%0%>");</script>'."\n";
		self::echo_html($script,'jp_protectbymd5_hash'.self::$i);
	}
	static private function jsdecode(){
		self::javascript();
		$script='<script type="text/javascript">js_protectbymd5_jsdecode("<%0%>");</script>'."\n";
		self::echo_html($script,'jp_protectbymd5_span'.self::$i);
	}
	static private function javascript(){
		// md5.js and script.js are included just once.
		static $shown=false;
		if ($shown) return;
		$shown=true;
		$jstag='<script type="text/javascript" src="<%0%>"></script>'."\n";
		self::echo_html($jstag,_CONF_URL_PLUGINS.'protectbymd5/md5.js');
		self::echo_html($jstag,_CONF_URL_PLUGINS.'protectbymd5/script.js');
	}
	static public function event_pre_action(&$data){
		// Check the acion to be analyzed.
		if (!self::option()->usethis) return;
		$actions=preg_split('/[\s]+/',self::option()->actions,-1,PREG_SPLIT_NO_EMPTY);
		if (!in_array($data['action'],$actions)) return;
		// The ticket was already checked by ticket class when the process reaches here.
		// Just return if the IP is accepted.
		if (self::option()->acceptlist) {
			if (js_ProtectByMD5_accept::check_ip($_SERVER['REMOTE_ADDR'])) return;
		}
		// Check MD5 hash
		$hash=isset($_POST['jp_protectbymd5_hash'])?$_POST['jp_protectbymd5_hash']:'empty';
		if ($hash==md5($_POST['ticket'])) return;
		// Leave a log if needed.
		if (self::option()->log) {
			if ($hash==$_POST['ticket']) core::log("Hash calculation failed.",__CLASS__,'spam');
			else core::log("Wrong hash: $hash",__CLASS__,'spam');	
		}
		// Show error message and exit.
		self::echo_html('<html><head><title>Error</title></head><body>Wrong MD5 hash or expired key!<br /><br /><%0%></body></html>',
			self::option()->errormessage);
		exit;
	}
}