/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.jdbcdebug.util;

import java.util.Properties;
import java.util.TimerTask;
import jp.co.powerbeans.jdbcdebug.util.ConCheckMgr;
import jp.co.powerbeans.jdbcdebug.util.ConnectionDtl;
import jp.co.powerbeans.jdbcdebug.util.Log;

public class ConCheckTask
extends TimerTask {
    public static long OUTPUT_OVER_TIME = 0L;
    public static long INTERVAL_TIME = 0L;

    public void run() {
        String[] keys = ConCheckMgr.getConMap().keySet().toArray(new String[0]);
        long now = System.currentTimeMillis();
        Log.println("[ConCheck] connection check start. connection num " + keys.length);
        int i = 0;
        while (i < keys.length) {
            long delta;
            ConnectionDtl dtl = (ConnectionDtl)ConCheckMgr.getConMap().get(keys[i]);
            if (dtl != null && (delta = now - dtl.getConStartTime()) >= OUTPUT_OVER_TIME) {
                Log.println("[ConCheck] ### forgot to close connection? " + delta / 60000L + ":" + delta / 1000L % 60L + "sec   expired.\n" + dtl.getTrace());
            }
            ++i;
        }
    }

    public static void applyProperties(Properties prop) {
        String con_check_task;
        String output_over_time = prop.getProperty("jdConOverTime");
        if (output_over_time != null) {
            try {
                OUTPUT_OVER_TIME = Long.parseLong(output_over_time);
            }
            catch (NumberFormatException e) {
                System.err.print("invalid param jdConOverTime=" + output_over_time);
            }
        }
        if ((con_check_task = prop.getProperty("jdConIntervalTime")) != null) {
            try {
                INTERVAL_TIME = Long.parseLong(con_check_task);
            }
            catch (NumberFormatException e) {
                System.err.print("invalid param jdConIntervalTime=" + con_check_task);
            }
        }
    }
}

