package jp.sourceforge.mailagent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * [M\[X
 */
class MailSource{
   private Map<String,String> frommap;         // MMap
   private Map<String,String> tomap;           // TO:Map
   private Map<String,String> ccmap;           // CC:Map
   private Map<String,String> bccmap;          // BCC:Map
   private String replyto;      // reply-to: ԐM
   private String subject;      // Subject: 
   private String message;      // [Me
   private List<File> templist;       // Ytt@CXg FileList
   
   protected MailSource(){
      this.frommap = new HashMap<String,String>();
      this.tomap = new HashMap<String,String>();
      this.ccmap = new HashMap<String,String>();
      this.bccmap = new HashMap<String,String>();
      this.templist = new ArrayList<File>();
   }
   protected void setFrom(String addres,String alias) {
      this.mailexpress(addres);
      this.frommap.put(addres,alias);
   }
   protected void setTo(String addres,String alias) {
      this.mailexpress(addres);
      this.tomap.put(addres,alias);
   }
   protected void setCC(String addres,String alias) {
      this.mailexpress(addres);
      this.ccmap.put(addres,alias);
   }
   protected void setBCC(String addres,String alias) {
      this.mailexpress(addres);
      this.bccmap.put(addres,alias);
   }
   protected String getReplyto(){
      return this.replyto;
   }
   protected void setReplyto(String replyto){
      this.replyto = replyto;
   }
   protected void setSubject(String subject){
      if (subject==null || subject.length()==0){
         throw new IllegalArgumentException("mail body Nothing!");
      }
      this.subject = Encode.convProphibitCode(Encode.convCp932toJIS(subject));
   }
   protected void setMessage(String message){
      if (message==null || message.length()==0){
         throw new IllegalArgumentException("mail body Nothing!");
      }
      this.message = message;
   }
   protected void setTemp(File[] files){
      for(int i=0;i < files.length;i++){
         if (files[i].exists()==false){
            throw new IllegalArgumentException("tempFile not exists!! : "+files[i].getPath());
         }
         this.templist.add(files[i]);
      }
   }
   protected void setTemp(File file){
      if (file.exists()==false){
         throw new IllegalArgumentException("tempFile not exists!! : "+file.getPath());
      }
      this.templist.add(file);
   }
   protected Map<String,String> getBccmap(){
      return this.bccmap;
   }
   protected Map<String,String> getCcmap(){
      return this.ccmap;
   }
   protected Map<String,String> getFrommap(){
      return this.frommap;
   }
   protected String getMessage(){
      return this.message;
   }
   protected String getSubject(){
      return this.subject;
   }
   protected List<File> getTemplist(){
      return this.templist;
   }
   protected Map<String,String> getTomap(){
      return this.tomap;
   }
   protected void clearTo(){
      this.tomap.clear();
      this.ccmap.clear();
      this.bccmap.clear();
   }
   protected void clearAll(){
      this.tomap.clear();
      this.ccmap.clear();
      this.bccmap.clear();
      this.frommap.clear();
      this.message = null;
      this.subject = null;
      this.replyto = null;
      this.templist.clear();
   }
   /**
    * [K\`FbN
    */
   private void mailexpress(String str){
      Pattern objPtn=Pattern.compile("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+"
                                     ,Pattern.CASE_INSENSITIVE);
      Matcher matcher = objPtn.matcher(str);
      if (matcher.matches()==false){
         throw new IllegalArgumentException("Illegal mail addres : "+str);
      }
   }
}
