package jp.sourceforge.mailagent;

/**
 * GR[h
 */
final class Encode{
   private Encode(){}
   /**
    * Unicode(cp932)  JIS ֕R[hϊ܂B
    * <PRE>
    *   F0xff3c[FULLWIDTH REVERSE SOLIDUS] -> 0x005c[REVERSE SOLIDUS]
    *   `F0xff5e[FULLWIDTH TILDE]           -> 0x301c[WAVE DASH]
    *   aF0x2225[PARALLEL TO]               -> 0x2016[DOUBLE VERTICAL LINE]
    *   |F0xff0d[FULLWIDTH HYPHEN-MINUS]    -> 0x2212[MINUS SIGN]
    *   F0xffe0[FULLWIDTH CENT SIGN]       -> 0x00a2[CENT SIGN]
    *   F0xffe1[FULLWIDTH POUND SIGN]      -> 0x00a3[POUND SIGN]
    *   ʁF0xffe2[FULLWIDTH NOT SIGN]        -> 0x00ac[NOT SIGN]
    * </PRE>
    * @param s ϊO<code>String</code>
    * @return ϊ㕶<code>String</code>
    */
   protected static String convCp932toJIS(String s) {
       if (s == null) return s;
       StringBuffer buffer = new StringBuffer();
       for (int i = 0; i < s.length(); i++) {
           char c  = s.charAt(i);
           switch (c) {
           case 0xff3c:    // FULLWIDTH REVERSE SOLIDUS ->
               c = 0x005c; // REVERSE SOLIDUS
               break;
           case 0xff5e:    // FULLWIDTH TILDE ->
               c = 0x301c; // WAVE DASH
               break;
           case 0x2225:    // PARALLEL TO ->
               c = 0x2016; // DOUBLE VERTICAL LINE
               break;
           case 0xff0d:    // FULLWIDTH HYPHEN-MINUS ->
               c = 0x2212; // MINUS SIGN
               break;
           case 0xffe0:    // FULLWIDTH CENT SIGN ->
               c = 0x00a2; // CENT SIGN
               break;
           case 0xffe1:    // FULLWIDTH POUND SIGN ->
               c = 0x00a3; // POUND SIGN
               break;
           case 0xffe2:    // FULLWIDTH NOT SIGN ->
               c = 0x00ac; // NOT SIGN
               break;
           }
           buffer.append(c);
       }
       return buffer.toString();
   }
 
   /**
    * ProphibitCode@̕ϊ.
    * [}Aې̕
    * @param s ϊO<code>String</code>
    * @return ϊ㕶<code>String</code>
    */
   protected static String convProphibitCode(String s){
      if (s == null) return s;
      StringBuffer sb = new StringBuffer();
      for (int i = 0; i < s.length(); i++) {
          char c  = s.charAt(i);
          switch (c) {
          case 0x2160:    // T->I
             c = 0x0049; 
             break;
          case 0x2161:    // U->II
             c = 0x0049;   sb.append(c);  c = 0x0049;
             break;
          case 0x2162:    // V->III
             c = 0x0049;   sb.append(c);  c = 0x0049;  sb.append(c);  c = 0x0049;
             break;
          case 0x2163:    // W->IV
             c = 0x0049;   sb.append(c);  c = 0x0056;
             break;
          case 0x2164:    // X->V
             c = 0x0056;
             break;
          case 0x2165:    // Y->VI
             c = 0x0056;   sb.append(c);  c = 0x0049;
             break;
          case 0x2166:    // Z->VII
             c = 0x0056;   sb.append(c);  c = 0x0049;  sb.append(c);  c = 0x0049;
             break;
          case 0x2167:    // [->VIII
             c = 0x0056;   sb.append(c);  c = 0x0049;  sb.append(c);  c = 0x0049;  sb.append(c);  c = 0x0049;
             break;
          case 0x2168:    // \->IX
             c = 0x0049;   sb.append(c);  c = 0x0058;
             break;
          case 0x2169:    // ]->X
             c = 0x0058;
             break;
          case 0x2170:    // @->i
             c = 0x0069;
             break;
          case 0x2171:    // A->ii
             c = 0x0069;   sb.append(c);  c = 0x0069;
             break;
          case 0x2172:    // B->iii
             c = 0x0069;   sb.append(c);  c = 0x0069;  sb.append(c);  c = 0x0069;
             break;
          case 0x2173:    // C->iv
             c = 0x0069;   sb.append(c);  c = 0x0076;
             break;
          case 0x2174:    // D->v
             c = 0x0076;
             break;
          case 0x2175:    // E->vi
             c = 0x0076;   sb.append(c);  c = 0x0069;
             break;
          case 0x2176:    // F->vii
             c = 0x0076;   sb.append(c);  c = 0x0069;  sb.append(c);  c = 0x0069;
             break;
          case 0x2177:    // G->viii
             c = 0x0076;   sb.append(c);  c = 0x0069;  sb.append(c);  c = 0x0069;  sb.append(c);  c = 0x0069;
             break;
          case 0x2178:    // H->ix
             c = 0x0069;   sb.append(c);  c = 0x0078;
             break;
          case 0x2179:    // I->x
             c = 0x0078;
             break;
          case 0x2460:    // @->(1)
             sb.append("(1");   c = ')';
             break;
          case 0x2461:    // A->(2)
             sb.append("(2");   c = ')';
             break;
          case 0x2462:    // B->(3)
             sb.append("(3");   c = ')';
             break;
          case 0x2463:    // C->(4)
             sb.append("(4");   c = ')';
             break;
          case 0x2464:    // D->(5)
             sb.append("(5");   c = ')';
             break;
          case 0x2465:    // E->(6)
             sb.append("(6");   c = ')'; 
             break;
          case 0x2466:    // F->(7)
             sb.append("(7");   c = ')';
             break;
          case 0x2467:    // G->(8)
             sb.append("(8");   c = ')';
             break;
          case 0x2468:    // H->(9)
             sb.append("(9");   c = ')';
             break;
          case 0x2469:    // I->(10)
             sb.append("(10");  c = ')';
             break;
          case 0x246a:    // J>(11)
             sb.append("(11");  c = ')';
             break;
          case 0x246b:    // K->(1)
             sb.append("(12");  c = ')';
             break;
          case 0x246c:    // L->(1)
             sb.append("(13");  c = ')';
             break;
          case 0x246d:    // M->(1)
             sb.append("(14");  c = ')';
             break;
          case 0x246e:    // N->(1)
             sb.append("(15");  c = ')';
             break;
          case 0x246f:    // O->(1)
             sb.append("(16");  c = ')';
             break;
          case 0x2470:    // P->(1)
             sb.append("(17");  c = ')';
             break;
          case 0x2471:    // Q->(1)
             sb.append("(18");  c = ')';
             break;
          case 0x2472:    // R->(1)
             sb.append("(19");  c = ')';
             break;
          case 0x2473:    // S->(1)
             sb.append("(20");  c = ')';
             break;
          }
          sb.append(c);
      }
      return sb.toString();
   }

}
