/**
 * Copyright 2014 Hanei Management Co.,Ltd. 
 * 
 * This file is part of Jaxcel
 * 
 *  Jaxcel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Jaxcel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.hanei.jaxcel.report;

import org.apache.poi.ss.usermodel.Sheet;

/**
 * Jaxcelコンテキスト
 * 
 * @version 1.00.00
 * @author noboru saito
 */
public class JaxcelContext {

	private Sheet currentSheet = null;
	private ELManager elManager = null;
	
	/**
	 * コンストラクタ
	 */
	public JaxcelContext() {}

	/**
	 * 参照中のWorksheetオブジェクトを返却
	 * 
	 * @return	参照中のWorksheetオブジェクト
	 */
	public Sheet getCurrentSheet() {
		return currentSheet;
	}

	/**
	 * 参照中とするWorksheetオブジェクトを設定
	 * 
	 * @param currentSheet	Worksheetオブジェクト
	 */
	public void setCurrentSheet(Sheet currentSheet) {
		this.currentSheet = currentSheet;
	}

	/**
	 * ELManagerオブジェクトを返却
	 * 
	 * @return ELManagerオブジェクト
	 */
	public ELManager getElManager() {
		return elManager;
	}

	/**
	 * ELManagerオブジェクトを設定
	 * 
	 * @param elManager ELManagerオブジェクト
	 */
	public void setElManager(ELManager elManager) {
		this.elManager = elManager;
	}

}
