/*
 * Decompiled with CFR 0.152.
 */
package org.hanei.jaxcel.report;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELManager {
    private static final Logger log = LoggerFactory.getLogger(ELManager.class);
    private final JexlEngine elEngine = new JexlEngine();
    private final JexlContext elContext = new MapContext();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public ELManager() {
    }

    public ELManager(Map<String, Object> parameter) {
        this.setParameter(parameter);
    }

    public void setParameter(Map<String, Object> parameter) {
        log.trace("setParameter start");
        if (parameter != null) {
            if (parameter.entrySet().size() == 0) {
                log.debug("parameter is no entry");
            } else {
                for (Map.Entry<String, Object> p : parameter.entrySet()) {
                    this.elContext.set(p.getKey(), p.getValue());
                    log.debug("parameter set: [{}]: {} {}", new Object[]{p.getKey(), p.getValue() == null ? "null" : p.getValue().getClass().getName(), p.getValue() == null ? "" : p.getValue().toString()});
                }
            }
        } else {
            log.debug("parameter is null");
        }
        log.trace("setParameter end");
    }

    public Object evaluate(String expression) {
        log.trace("evaluate start");
        Object object = null;
        if (expression == null) {
            log.debug("expression is null");
        } else {
            log.debug("expression: {}", (Object)expression);
            try {
                Expression expr = this.elEngine.createExpression(expression);
                object = expr.evaluate(this.elContext);
            }
            catch (Exception e) {
                log.error("evaluate error: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        if (object == null) {
            log.debug("evaluate result is null");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("evaluate result: {}", (Object)object.toString());
                log.debug("evaluate result type: {}", (Object)object.getClass().getName());
            }
            if (object instanceof Date) {
                object = this.sdf.format(object);
            } else if (object instanceof Calendar) {
                object = this.sdf.format(((Calendar)object).getTime());
            }
        }
        log.trace("evaluate end");
        return object;
    }
}

