/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectConverter
implements Converter {
    private Class<?> cls;
    private transient Map<String, PropertyInfo> props;

    public ObjectConverter(Class<?> cls) {
        this.cls = cls;
    }

    @Override
    public boolean accept(Class<?> cls) {
        return !cls.isPrimitive();
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (this.props == null) {
            this.props = ObjectConverter.getSetProperties(context, this.cls);
        }
        if (value instanceof Map) {
            Object o = context.createInternal(c);
            if (o == null) {
                return null;
            }
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String name = entry.getKey().toString();
                PropertyInfo target = this.props.get(name);
                if (target == null) {
                    target = this.props.get(ObjectConverter.toLowerCamel(context, name));
                }
                if (target == null) continue;
                JSONHint hint = target.getWriteAnnotation(JSONHint.class);
                context.enter(name, hint);
                Class<?> cls = target.getWriteType();
                Type gtype = target.getWriteGenericType();
                if (gtype instanceof TypeVariable && t instanceof ParameterizedType) {
                    gtype = ObjectConverter.resolveTypeVariable((TypeVariable)gtype, (ParameterizedType)t);
                    cls = ClassUtil.getRawType(gtype);
                }
                target.set(o, context.postparseInternal(entry.getValue(), cls, gtype));
                context.exit();
            }
            return o;
        }
        if (value instanceof List) {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
        }
        JSONHint hint = context.getHint();
        if (hint != null && hint.anonym().length() > 0) {
            PropertyInfo target = this.props.get(hint.anonym());
            if (target == null) {
                return null;
            }
            Object o = context.createInternal(c);
            if (o == null) {
                return null;
            }
            JSONHint hint2 = target.getWriteAnnotation(JSONHint.class);
            context.enter(hint.anonym(), hint2);
            Class<?> cls = target.getWriteType();
            Type gtype = target.getWriteGenericType();
            if (gtype instanceof TypeVariable && t instanceof ParameterizedType) {
                gtype = ObjectConverter.resolveTypeVariable((TypeVariable)gtype, (ParameterizedType)t);
                cls = ClassUtil.getRawType(gtype);
            }
            target.set(o, context.postparseInternal(value, cls, gtype));
            context.exit();
            return o;
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }

    private static Map<String, PropertyInfo> getSetProperties(JSON.Context context, Class<?> c) {
        int ordinal;
        String name;
        JSONHint hint;
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
            Field f = prop.getField();
            if (f == null || Modifier.isFinal(f.getModifiers()) || context.ignoreInternal(c, f)) continue;
            hint = f.getAnnotation(JSONHint.class);
            name = null;
            ordinal = prop.getOrdinal();
            if (hint != null) {
                if (hint.ignore()) continue;
                ordinal = hint.ordinal();
                if (hint.name().length() != 0) {
                    name = hint.name();
                }
            }
            if (name == null) {
                name = context.normalizeInternal(prop.getName());
                if (context.getPropertyStyle() != null) {
                    name = context.getPropertyStyle().to(name);
                }
            }
            if (!name.equals(prop.getName()) || ordinal != prop.getOrdinal() || f != prop.getWriteMember()) {
                props.put(name, new PropertyInfo(prop.getBeanClass(), name, prop.getField(), null, null, prop.isStatic(), ordinal));
                continue;
            }
            props.put(name, prop);
        }
        for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
            Method m = prop.getWriteMethod();
            if (m == null || context.ignoreInternal(c, m)) continue;
            hint = m.getAnnotation(JSONHint.class);
            name = null;
            ordinal = prop.getOrdinal();
            if (hint != null) {
                if (hint.ignore()) continue;
                ordinal = hint.ordinal();
                if (hint.name().length() != 0) {
                    name = hint.name();
                }
            }
            if (name == null) {
                name = context.normalizeInternal(prop.getName());
                if (context.getPropertyStyle() != null) {
                    name = context.getPropertyStyle().to(name);
                }
            }
            if (!name.equals(prop.getName()) || ordinal != prop.getOrdinal()) {
                prop = new PropertyInfo(prop.getBeanClass(), name, null, null, prop.getWriteMethod(), prop.isStatic(), ordinal);
            }
            if (prop.getWriteMethod() != null) {
                prop.getWriteMethod().setAccessible(true);
            } else if (prop.getField() != null) {
                prop.getField().setAccessible(true);
            }
            props.put(name, prop);
        }
        return props;
    }

    private static String toLowerCamel(JSON.Context context, String name) {
        StringBuilder sb = context.getLocalCache().getCachedBuffer();
        boolean toUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(0)) && !Character.isUpperCase(sb.charAt(1))) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return context.getLocalCache().getString(sb);
    }

    private static Type resolveTypeVariable(TypeVariable<?> type, ParameterizedType parent) {
        Class<?> rawType = ClassUtil.getRawType(parent);
        if (rawType.equals(type.getGenericDeclaration())) {
            String tvName = type.getName();
            TypeVariable<Class<?>>[] rtypes = rawType.getTypeParameters();
            Type[] atypes = parent.getActualTypeArguments();
            for (int i = 0; i < rtypes.length; ++i) {
                if (!tvName.equals(rtypes[i].getName())) continue;
                return atypes[i];
            }
        }
        return type.getBounds()[0];
    }
}

