/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;

import ch.kuramo.javie.core.JavieRuntimeException;

import com.jogamp.opengl.impl.macosx.cgl.CGL;
import com.jogamp.opengl.impl.macosx.cgl.MacOSXCGLDrawable;

public class MacOSXOpenGLPixelFormat {

	private static final Method methodGLCapabilities2NSPixelFormat;

	static {
		try {
			Class<?> clazz = Class.forName("com.jogamp.opengl.impl.macosx.cgl.MacOSXCGLGraphicsConfiguration");
			Method method = clazz.getDeclaredMethod("GLCapabilities2NSPixelFormat", GLCapabilitiesImmutable.class);
			method.setAccessible(true);
			methodGLCapabilities2NSPixelFormat = method;
		} catch (SecurityException e) {
			throw new JavieRuntimeException(e);
		} catch (ClassNotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (NoSuchMethodException e) {
			throw new JavieRuntimeException(e);
		}		
	}

	public static long createPixelFormat(GLContext context) {
		GLCapabilitiesImmutable caps = ((MacOSXCGLDrawable) context.getGLDrawable()).getChosenGLCapabilities();
		try {
			return (Long) methodGLCapabilities2NSPixelFormat.invoke(null, caps);
		} catch (IllegalArgumentException e) {
			throw new JavieRuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new JavieRuntimeException(e);
		} catch (InvocationTargetException e) {
			throw new JavieRuntimeException(e);
		}
	}

	public static void deletePixelFormat(long pixelFormat) {
		CGL.deletePixelFormat(pixelFormat);
	}


	private MacOSXOpenGLPixelFormat() { }

}
