/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * <p><code>Size2i</code> クラスは、整数値による幅と高さで矩形領域のサイズを表現します。
 * 値が整数値で保持されるため、<code>Size2i</code> クラスの主な用途はコンポジションのサイズや画像のサイズなどです。</p>
 * 
 * <p><code>Size2i</code> オブジェクトは不変です。
 * <code>Size2i</code> オブジェクトは作成したあとに変更できないため、共用することができます。</p>
 */
public final class Size2i {

	/**
	 * 幅です。
	 */
	public final int width;

	/**
	 * 高さです。
	 */
	public final int height;


	/**
	 * 幅と高さを指定して <code>Size2i</code> オブジェクトを生成します。
	 * 
	 * @param width  幅
	 * @param height 高さ
	 */
	public Size2i(int width, int height) {
		super();
		this.width = width;
		this.height = height;
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + height;
		result = prime * result + width;
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Size2i other = (Size2i) obj;
		if (height != other.height)
			return false;
		if (width != other.width)
			return false;
		return true;
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Size2i [width=" + width + ", height=" + height + "]";
	}

}
