/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * <p>{@link IArray} のオブジェクト配列版です。
 * {@link ch.kuramo.javie.api.services.IArrayPools#getObjectArray(int)} から返されます。</p>
 * 
 * <p>型パラメータ<code>T</code>により<code>IObjectArray&lt;T&gt;</code>オブジェクト自体の型安全性は保証されますが、
 * {@link #getArray()} から返される生の配列は<code>Object[]</code>なので
 * 配列の要素を使用する際は適切にキャストする必要があります。</p>
 *
 * @param <T> オブジェクト配列の要素の型
 * 
 * @see ch.kuramo.javie.api.services.IArrayPools#getObjectArray(int)
 */
public interface IObjectArray<T> extends IArray<Object[]> {

}
