/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * <code>IAudioBuffer</code>はオーディオ用バッファです。
 * {@link ch.kuramo.javie.api.services.IAudioEffectContext#doPreviousEffect()} から返される他、
 * {@link ch.kuramo.javie.api.services.IEffectContext#createAudioBuffer()} で作成することができます。
 */
public interface IAudioBuffer {

	/**
	 * このオーディオ用バッファを破棄します。
	 */
	void dispose();

	/**
	 * このオーディオ用バッファの {@link AudioMode} を返します。
	 * 
	 * @return このオーディオ用バッファの {@link AudioMode}
	 */
	AudioMode getAudioMode();

	/**
	 * このオーディオ用バッファのサンプルフレーム数を返します。
	 * 
	 * @return このオーディオ用バッファのサンプルフレーム数
	 */
	int getFrameCount();

	/**
	 * このオーディオ用バッファの要素数を返します。
	 * {@link #getData()} が返す配列のうち、この要素数分だけが使用可能です。
	 * この値は、<code>getFrameCount() * getAudioMode().channels</code> と同じです。
	 * 
	 * @return このオーディオ用バッファの要素数
	 * @see #getData()
	 */
	int getDataLength();

	/**
	 * <p>このオーディオ用バッファの配列を返します。配列の実際の型は {@link #getAudioMode()}
	 * が返す<code>AudioMode</code>の {@link AudioMode#dataType} により、
	 * <code>short[]</code>, <code>int[]</code>, <code>float[]</code> のいずれかとなります。
	 * 配列のサイズは {@link #getDataLength()} が返す要素数よりも大きい場合がありますが、
	 * <code>getDataLength()</code> の分だけが使用可能です。</p>
	 * 
	 * <code>AudioMode</code>のチャンネル数が2(ステレオ)の場合、
	 * この配列内のデータは左チャンネル、右チャンネルの順に1サンプルずつ交互に並んでいます。
	 * 
	 * @return このオーディオ用バッファの配列
	 * @see #getDataLength()
	 */
	Object getData();

}
