/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.mapping.voronoi;

import com.iabcinc.mapping.voronoi.Point;
import com.iabcinc.mapping.voronoi.QuadEdge;
import com.iabcinc.mapping.voronoi.RegionFilter;
import com.iabcinc.mapping.voronoi.VoronoiPolygon;
import com.iabcinc.mapping.voronoi.VoronoiRegion;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triangulation {
    private static final long serialVersionUID = -3967176215749113937L;
    Vector<QuadEdge> quadEdges = null;
    private boolean voronoiEdgesBuilt = false;
    public static final int FLAG_EDGE_LEFT_USED = 1;
    public static final int FLAG_EDGE_DELETED = 2;
    public static final int FLAG_POINT_INFINITE = 1;

    public Triangulation(Point ul, Point lr) {
        double ulx = Math.min(ul.getX(), lr.getX());
        double uly = Math.max(ul.getY(), lr.getY());
        double lrx = Math.max(ul.getX(), lr.getX());
        double lry = Math.min(ul.getY(), lr.getY());
        double w = lrx - ulx;
        double h = uly - lry;
        Point e1 = new Point(ulx - h, lry);
        Point e2 = new Point(lrx + h, lry);
        Point e3 = new Point(ulx + w / 2.0, uly + w / 2.0);
        this.init(e1, e2, e3);
    }

    public Triangulation() {
        this(new Point(-150.0, 50.0), new Point(50.0, 0.0));
    }

    public Triangulation(Point p1, Point p2, Point p3) {
        this.init(p1, p2, p3);
    }

    private void init(Point p1, Point p2, Point p3) {
        this.quadEdges = new Vector();
        QuadEdge e1 = new QuadEdge();
        QuadEdge e2 = new QuadEdge();
        QuadEdge e3 = new QuadEdge();
        p1.setFlag(1);
        p2.setFlag(1);
        p3.setFlag(1);
        e1.setOrg(p1);
        e2.setOrg(p2);
        e3.setOrg(p3);
        e1.setDest(e2.getOrg());
        e2.setDest(e3.getOrg());
        e3.setDest(e1.getOrg());
        e1.setOnext(e3.sym());
        e1.rot().setOnext(e3.rot());
        e1.sym().setOnext(e2);
        e1.invrot().setOnext(e2.invrot());
        e2.setOnext(e1.sym());
        e2.rot().setOnext(e1.rot());
        e2.sym().setOnext(e3);
        e2.invrot().setOnext(e3.invrot());
        e3.setOnext(e2.sym());
        e3.rot().setOnext(e2.rot());
        e3.sym().setOnext(e1);
        e3.invrot().setOnext(e1.invrot());
        this.quadEdges.add(e1);
        this.quadEdges.add(e2);
        this.quadEdges.add(e3);
    }

    private static void splice(QuadEdge a, QuadEdge b) {
        QuadEdge aa = a.onext().rot();
        QuadEdge bb = b.onext().rot();
        QuadEdge t1 = b.onext();
        QuadEdge t2 = a.onext();
        QuadEdge t3 = bb.onext();
        QuadEdge t4 = aa.onext();
        a.setOnext(t1);
        b.setOnext(t2);
        aa.setOnext(t3);
        bb.setOnext(t4);
    }

    private QuadEdge connect(QuadEdge a, QuadEdge b) {
        QuadEdge e = new QuadEdge();
        this.quadEdges.add(e);
        e.setOrg(a.getDest());
        e.setDest(b.getOrg());
        Triangulation.splice(e, a.lnext());
        Triangulation.splice(e.sym(), b);
        return e;
    }

    private void deleteEdge(QuadEdge e) {
        Triangulation.splice(e, e.oprev());
        Triangulation.splice(e.sym(), e.sym().oprev());
        e.setFlag(2);
        e.rot().setFlag(2);
        e.sym().setFlag(2);
        e.invrot().setFlag(2);
    }

    private void sweepEdges() {
        Iterator<QuadEdge> i = this.quadEdges.iterator();
        int c = 0;
        while (i.hasNext()) {
            QuadEdge e = i.next();
            if (!e.isFlagSet(2)) continue;
            i.remove();
            ++c;
        }
    }

    private static void swap(QuadEdge e) {
        QuadEdge a = e.oprev();
        QuadEdge b = e.sym().oprev();
        Triangulation.splice(e, a);
        Triangulation.splice(e.sym(), b);
        Triangulation.splice(e, a.lnext());
        Triangulation.splice(e.sym(), b.lnext());
        e.setOrg(a.getDest());
        e.setDest(b.getDest());
    }

    public void insertSite(double x, double y) {
        this.insertSite(new Point(x, y));
    }

    public void insertSite(Point pt) {
        QuadEdge newEdge;
        QuadEdge e = this.locateContainingTriangleEdge(pt);
        if (e == null) {
            return;
        }
        QuadEdge startingEdge = newEdge = new QuadEdge();
        this.quadEdges.add(newEdge);
        newEdge.setOrg(e.getOrg());
        newEdge.setDest(pt);
        Triangulation.splice(newEdge, e);
        newEdge = this.connect(e, newEdge.sym());
        newEdge = this.connect(newEdge.oprev(), newEdge.sym());
        e = newEdge.oprev();
        while (true) {
            QuadEdge t = e.oprev();
            if (pt.isInCircle(e.getOrg(), t.getDest(), e.getDest())) {
                Triangulation.swap(e);
                e = e.oprev();
                continue;
            }
            if (e.onext() == startingEdge) {
                return;
            }
            e = e.onext().lprev();
        }
    }

    private QuadEdge locateContainingTriangleEdge(Point p) {
        QuadEdge start;
        QuadEdge e = start = this.quadEdges.get(0);
        int cnt = 0;
        while (!(p.equals(e.getOrg()) || p.equals(e.getDest()) || p.isOn(e))) {
            if (p.isRightOf(e)) {
                e = e.sym();
            } else if (!p.isRightOf(e.onext())) {
                e = e.onext();
            } else if (!p.isRightOf(e.dprev())) {
                e = e.dprev();
            } else {
                return e;
            }
            if (e == start || cnt > 1000) {
                return null;
            }
            ++cnt;
        }
        return e;
    }

    private void buildVoronoiEdges() {
        this.sweepEdges();
        for (QuadEdge e : this.quadEdges) {
            Point pl = Triangulation.getVoronoiVertex(e, e.onext());
            Point pr = Triangulation.getVoronoiVertex(e, e.oprev());
            e.dual().setOrg(pr);
            e.dual().setDest(pl);
        }
        this.voronoiEdgesBuilt = true;
    }

    private static Point getVoronoiVertex(QuadEdge e1, QuadEdge e2) {
        Point pnt = new Point(0.0, 0.0);
        double x2 = e1.getOrg().getX();
        double y2 = e1.getOrg().getY();
        double x1 = e1.getDest().getX();
        double y1 = e1.getDest().getY();
        double x3 = e2.getDest().getX();
        double y3 = e2.getDest().getY();
        double det = (y2 - y3) * (x2 - x1) - (y2 - y1) * (x2 - x3);
        double c1 = (x1 + x2) * (x2 - x1) / 2.0 + (y2 - y1) * (y1 + y2) / 2.0;
        double c2 = (x2 + x3) * (x2 - x3) / 2.0 + (y2 - y3) * (y2 + y3) / 2.0;
        pnt.setX((c1 * (y2 - y3) - c2 * (y2 - y1)) / det);
        pnt.setY((c2 * (x2 - x1) - c1 * (x2 - x3)) / det);
        return pnt;
    }

    private VoronoiPolygon buildRegionPolygon(QuadEdge firstRegionEdge, RegionFilter filter) {
        VoronoiPolygon polygon = new VoronoiPolygon();
        QuadEdge regionEdge = firstRegionEdge;
        String regionName = filter.getRegionName(firstRegionEdge.rot().getOrg());
        System.out.println("Building Region " + regionName);
        do {
            QuadEdge edge;
            block3: {
                regionEdge.setFlag(1);
                polygon.add(regionEdge);
                edge = regionEdge.lnext();
                QuadEdge firstEdge = regionEdge.lnext();
                while (true) {
                    if (edge.isLeftRegionEdge(filter)) break block3;
                    edge = edge.oprev();
                    assert (edge != firstEdge);
                }
            }
            regionEdge = edge;
        } while (regionEdge != firstRegionEdge);
        if (!polygon.isOuter()) {
            System.out.println("  >> Inner Polygon!");
        }
        return polygon;
    }

    public Vector<VoronoiRegion> getVoronoiRegions(RegionFilter filter) {
        Vector<VoronoiPolygon> polygons = new Vector<VoronoiPolygon>();
        if (!this.voronoiEdgesBuilt) {
            this.buildVoronoiEdges();
        }
        for (QuadEdge edge : this.quadEdges) {
            edge.rot().clearFlag(1);
            edge.invrot().clearFlag(1);
        }
        for (QuadEdge edge : this.quadEdges) {
            QuadEdge faceEdge = edge.rot();
            if (!faceEdge.isFlagSet(1) && faceEdge.isLeftRegionEdge(filter)) {
                polygons.add(this.buildRegionPolygon(faceEdge, filter));
            }
            if ((faceEdge = edge.invrot()).isFlagSet(1) || !faceEdge.isLeftRegionEdge(filter)) continue;
            polygons.add(this.buildRegionPolygon(faceEdge, filter));
        }
        VoronoiRegionContainer container = new VoronoiRegionContainer();
        container.process(polygons);
        return container.getVoronoiRegions();
    }

    public Vector<QuadEdge> getVoronoiEdges() {
        Vector<QuadEdge> edges = new Vector<QuadEdge>();
        if (!this.voronoiEdgesBuilt) {
            this.buildVoronoiEdges();
        }
        for (QuadEdge edge : this.quadEdges) {
            if (edge.getOrg().isFlagSet(1) && edge.sym().getOrg().isFlagSet(1)) continue;
            edges.add(edge.rot());
        }
        return edges;
    }

    public Vector getDelaunayEdges() {
        Vector<QuadEdge> edges = new Vector<QuadEdge>();
        if (!this.voronoiEdgesBuilt) {
            this.buildVoronoiEdges();
        }
        for (QuadEdge edge : this.quadEdges) {
            if (edge.getOrg().isFlagSet(1) && edge.sym().getOrg().isFlagSet(1)) continue;
            edges.add(edge);
        }
        return edges;
    }

    private VoronoiPolygon buildVoronoiPolygon(QuadEdge firstEdge) {
        if (firstEdge.isFlagSet(1)) {
            return null;
        }
        if (firstEdge.getOrg().isFlagSet(1)) {
            return null;
        }
        VoronoiPolygon polygon = new VoronoiPolygon();
        QuadEdge nextEdge = firstEdge;
        QuadEdge edge = null;
        QuadEdge dual = null;
        do {
            edge = nextEdge;
            dual = edge.rot();
            polygon.add(dual);
            edge.setFlag(1);
        } while ((nextEdge = edge.onext()) != firstEdge);
        return polygon;
    }

    public Vector<VoronoiPolygon> getVoronoiPolygons() {
        Vector<VoronoiPolygon> polygons = new Vector<VoronoiPolygon>();
        if (!this.voronoiEdgesBuilt) {
            this.buildVoronoiEdges();
        }
        for (QuadEdge edge : this.quadEdges) {
            VoronoiPolygon polygon = this.buildVoronoiPolygon(edge);
            if (polygon != null) {
                polygons.add(polygon);
            }
            if ((polygon = this.buildVoronoiPolygon(edge.sym())) == null) continue;
            polygons.add(polygon);
        }
        return polygons;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VoronoiRegionContainer {
        private Vector<VoronoiRegion> regions = new Vector();

        private void addOuter(Vector<VoronoiPolygon> polygons) {
            for (VoronoiPolygon polygon : polygons) {
                if (!polygon.isOuter()) continue;
                VoronoiRegion region = new VoronoiRegion();
                region.setOuterPolygon(polygon);
                this.regions.add(region);
            }
        }

        private void addInner(Vector<VoronoiPolygon> polygons) {
            block0: for (VoronoiPolygon polygon : polygons) {
                if (polygon.isOuter()) continue;
                for (VoronoiRegion region : this.regions) {
                    if (!region.getOuterPolygon().contains(polygon)) continue;
                    region.addInnerPolygon(polygon);
                    continue block0;
                }
                assert (false);
            }
        }

        private void process(Vector<VoronoiPolygon> polygons) {
            this.addOuter(polygons);
            this.addInner(polygons);
        }

        public Vector<VoronoiRegion> getVoronoiRegions() {
            return this.regions;
        }
    }
}

