/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

public final class Color {
    public static final Color COLORLESS_TRANSPARENT = new Color(0.0, 0.0, 0.0, 0.0);
    public static final Color BLACK = new Color(0.0, 0.0, 0.0, 1.0);
    public static final Color WHITE = new Color(1.0, 1.0, 1.0, 1.0);
    public static final Color GRAY = new Color(0.5, 0.5, 0.5, 1.0);
    public final double r;
    public final double g;
    public final double b;
    public final double a;
    public final double rawRed;
    public final double rawGreen;
    public final double rawBlue;
    public final double rawAlpha;

    public Color(double red, double green, double blue, double alpha) {
        this.rawRed = red;
        this.rawGreen = green;
        this.rawBlue = blue;
        this.rawAlpha = alpha;
        this.r = Double.isNaN(red) ? 0.0 : Math.max(0.0, Math.min(1.0, red));
        this.g = Double.isNaN(green) ? 0.0 : Math.max(0.0, Math.min(1.0, green));
        this.b = Double.isNaN(blue) ? 0.0 : Math.max(0.0, Math.min(1.0, blue));
        this.a = Double.isNaN(alpha) ? 1.0 : Math.max(0.0, Math.min(1.0, alpha));
    }

    public Color(double red, double green, double blue) {
        this(red, green, blue, 1.0);
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.rawAlpha);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rawBlue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rawGreen);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rawRed);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        if (Double.doubleToLongBits(this.rawAlpha) != Double.doubleToLongBits(other.rawAlpha)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rawBlue) != Double.doubleToLongBits(other.rawBlue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rawGreen) != Double.doubleToLongBits(other.rawGreen)) {
            return false;
        }
        return Double.doubleToLongBits(this.rawRed) == Double.doubleToLongBits(other.rawRed);
    }

    public String toString() {
        return "Color [r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
    }
}

