/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.voodoo2javie;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.widgets.FrameRateComboUtil;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.TimeCode;
import ch.kuramo.javie.core.Util;
import ch.kuramo.voodoo2javie.Voodoo2Javie;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class Voodoo2JavieWizardPage
extends WizardPage {
    private final Voodoo2Javie v2j;
    private final ProjectManager pm;
    private Text scaleText;
    private Label sizeLabel;
    private Combo fpsCombo;
    private Label durationLabel;
    private Button newCompRadio;
    private Text newCompText;
    private Button addCameraRadio;
    private Combo addCameraCombo;
    private List<LayerComposition> compositions;

    Voodoo2JavieWizardPage(Voodoo2Javie v2j, ProjectManager pm) {
        super("Voodoo2JavieWizardPage", "\u8aad\u307f\u8fbc\u307f\u8a2d\u5b9a", null);
        this.v2j = v2j;
        this.pm = pm;
    }

    public void createControl(Composite parent) {
        GridBuilder gb = new GridBuilder(parent, 1, false);
        ((GridLayout)gb.getComposite().getLayout()).verticalSpacing = 0;
        this.createCameraDataGroup(gb);
        gb.size(10, 10).composite(0);
        this.createCompositionGroup(gb);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.setControl((Control)grid);
        this.doValidate();
    }

    private void createCameraDataGroup(GridBuilder gb) {
        Group group = gb.hAlign(4).hGrab().group(0, "\u30ab\u30e1\u30e9\u30c7\u30fc\u30bf");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 6, false);
        gb2.hSpan(1).hAlign(131072).label(0, "\u30b5\u30a4\u30ba:");
        gb2.hSpan(5).hAlign(16384).label(0, String.format("%d x %d", this.v2j.getWidth(), this.v2j.getHeight()));
        gb2.hSpan(1).hAlign(131072).label(0, "\u30b9\u30b1\u30fc\u30eb:");
        this.scaleText = gb2.hSpan(1).hAlign(4).width(40).text(2048, "100");
        gb2.hSpan(1).hAlign(16384).label(0, "%");
        this.sizeLabel = gb2.hSpan(3).hAlign(4).hGrab().label(0, "");
        gb2.hSpan(6).size(10, 10).composite(0);
        gb2.hSpan(1).hAlign(131072).label(0, "\u30d5\u30ec\u30fc\u30e0\u6570:");
        gb2.hSpan(5).hAlign(16384).label(0, String.valueOf(this.v2j.getFrameCount()));
        gb2.hSpan(1).hAlign(131072).label(0, "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8:");
        this.fpsCombo = gb2.hSpan(1).hAlign(16384).combo(0, 0, FrameRateComboUtil.getComboItems(), FrameRateComboUtil.toComboItem(FrameDuration.FPS_29_97));
        gb2.hSpan(4).hAlign(16384).label(0, "\u30d5\u30ec\u30fc\u30e0\uff0f\u79d2");
        gb2.hSpan(1).hAlign(131072).label(0, "\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3:");
        this.durationLabel = gb2.hSpan(5).hAlign(4).hGrab().label(0, "");
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Voodoo2JavieWizardPage.this.doValidate();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Voodoo2JavieWizardPage.this.doValidate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Voodoo2JavieWizardPage.this.doValidate();
            }
        };
        this.scaleText.addModifyListener(modifyListener);
        this.fpsCombo.addModifyListener(modifyListener);
        this.fpsCombo.addSelectionListener(selectionListener);
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void createCompositionGroup(GridBuilder gb) {
        List compNames = Util.newList();
        this.compositions = Util.newList();
        for (Item item : this.pm.getProject().getItems()) {
            Composition comp;
            if (!(item instanceof CompositionItem) || !((comp = ((CompositionItem)item).getComposition()) instanceof LayerComposition)) continue;
            Size2i size = comp.getSize();
            compNames.add(String.format("%s (%d x %d)", item.getName(), size.width, size.height));
            this.compositions.add((LayerComposition)comp);
        }
        Group group = gb.hAlign(4).hGrab().group(0, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 3, false);
        this.newCompRadio = gb2.hSpan(1).hAlign(16384).button(16, "\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3:");
        this.newCompText = gb2.hSpan(2).hAlign(4).hGrab().text(2048, this.pm.getUnusedItemName("\u30b3\u30f3\u30dd"));
        this.newCompRadio.setSelection(true);
        if (compNames.isEmpty()) {
            this.addCameraRadio = gb2.hSpan(2).hAlign(16384).button(16, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306b\u30ab\u30e1\u30e9\u3092\u8ffd\u52a0:");
            this.addCameraCombo = gb2.hSpan(1).hAlign(16384).combo(8, new String[]{""});
            this.addCameraRadio.setEnabled(false);
            this.addCameraCombo.setEnabled(false);
        } else {
            this.addCameraRadio = gb2.hSpan(2).hAlign(16384).button(16, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306b\u30ab\u30e1\u30e9\u3092\u8ffd\u52a0:");
            this.addCameraCombo = gb2.hSpan(1).hAlign(16384).combo(8, 20, compNames.toArray(new String[compNames.size()]), (String)compNames.get(0));
            this.addCameraCombo.setEnabled(false);
        }
        this.newCompRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Voodoo2JavieWizardPage.this.newCompText.setEnabled(true);
                Voodoo2JavieWizardPage.this.addCameraCombo.setEnabled(false);
                Voodoo2JavieWizardPage.this.doValidate();
            }
        });
        this.addCameraRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Voodoo2JavieWizardPage.this.newCompText.setEnabled(false);
                Voodoo2JavieWizardPage.this.addCameraCombo.setEnabled(true);
                Voodoo2JavieWizardPage.this.doValidate();
            }
        });
        this.newCompText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Voodoo2JavieWizardPage.this.doValidate();
            }
        });
        this.addCameraCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Voodoo2JavieWizardPage.this.doValidate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Voodoo2JavieWizardPage.this.doValidate();
            }
        });
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void doValidate() {
        double fps;
        double scale;
        this.setPageComplete(false);
        try {
            scale = Double.parseDouble(this.scaleText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            scale = 0.0;
        }
        String fpsStr = this.fpsCombo.getText().trim();
        try {
            fps = Double.parseDouble(fpsStr);
        }
        catch (NumberFormatException numberFormatException) {
            fps = 0.0;
        }
        int width = (int)Math.round((double)this.v2j.getWidth() * scale * 0.01);
        int height = (int)Math.round((double)this.v2j.getHeight() * scale * 0.01);
        if (scale > 0.0) {
            this.sizeLabel.setText(String.format("= %d x %d", width, height));
        } else {
            this.sizeLabel.setText("");
        }
        if (fps >= 1.0) {
            Time frameDuration = FrameRateComboUtil.toFrameDuration(fpsStr);
            String timeCode = TimeCode.toTimeCode((Time)Time.fromFrameNumber((long)this.v2j.getFrameCount(), (Time)frameDuration), (Time)frameDuration);
            int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
            boolean drop = timeCode.indexOf(59) != -1;
            this.durationLabel.setText(String.format("%s (\u30d9\u30fc\u30b9 %d%s)", timeCode, base, drop ? "\u30c9\u30ed\u30c3\u30d7" : ""));
        } else {
            this.durationLabel.setText("");
        }
        String warnMsg = null;
        String errMsg = null;
        if (this.newCompRadio.getSelection()) {
            if (errMsg == null && (width < 1 || width > 8192 || height < 1 || height > 8192)) {
                errMsg = String.format("\u30b5\u30a4\u30ba\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002\u5e45\u304a\u3088\u3073\u9ad8\u3055\u304c1\u304b\u3089%d\u3068\u306a\u308b\u3088\u3046\u306b\u30b9\u30b1\u30fc\u30eb\u306e\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192);
            }
        } else {
            LayerComposition comp = this.compositions.get(this.addCameraCombo.getSelectionIndex());
            Size2i size = comp.getSize();
            if (warnMsg == null && (width != size.width || height != size.height)) {
                warnMsg = "\u30b5\u30a4\u30ba\u304c\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u3068\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
            }
        }
        if (errMsg == null && fpsStr.length() == 0) {
            errMsg = "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        }
        if (errMsg == null && fps < 1.0) {
            errMsg = "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u306b\u306f1\u4ee5\u4e0a\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        }
        if (errMsg == null && this.newCompRadio.getSelection() && this.newCompText.getText().trim().length() == 0) {
            errMsg = "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        }
        this.setMessage(warnMsg, 2);
        this.setErrorMessage(errMsg);
        this.setPageComplete(errMsg == null);
    }

    double getScale() {
        if (this.isPageComplete()) {
            return Double.parseDouble(this.scaleText.getText().trim()) * 0.01;
        }
        throw new IllegalStateException();
    }

    Time getFrameDuration() {
        if (this.isPageComplete()) {
            return FrameRateComboUtil.toFrameDuration(this.fpsCombo.getText().trim());
        }
        throw new IllegalStateException();
    }

    String getNewCompositionName() {
        if (this.isPageComplete()) {
            return this.newCompRadio.getSelection() ? this.newCompText.getText().trim() : null;
        }
        throw new IllegalStateException();
    }

    LayerComposition getComposition() {
        if (this.isPageComplete()) {
            return this.newCompRadio.getSelection() ? null : this.compositions.get(this.addCameraCombo.getSelectionIndex());
        }
        throw new IllegalStateException();
    }
}

