/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.app.views.layercomp.LayerSwitch;
import ch.kuramo.javie.app.views.layercomp.Switch;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class SwitchGroup {
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    private final List<Switch> switches = Util.newList();
    private final List<Rectangle> switchArea = Util.newList();
    private int marginLeft = 5;

    public void removeAll() {
        this.switches.clear();
        this.switchArea.clear();
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void add(Switch s) {
        this.switches.add(s);
    }

    public void addPlaceholder() {
        this.switches.add(null);
    }

    public void redraw(Control control) {
        for (Rectangle r : this.switchArea) {
            control.redraw(r.x, r.y, r.width, r.height, false);
        }
    }

    public void paint(Event event) {
        this.switchArea.clear();
        int i = 0;
        int n = this.switches.size();
        while (i < n) {
            this.paintSwitch(event, i, this.switches.get(i));
            ++i;
        }
    }

    public void mouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        int i = 0;
        int n = this.switchArea.size();
        while (i < n) {
            Rectangle r = this.switchArea.get(i);
            if (r != null && r.contains(event.x, event.y)) {
                Object savedData = event.data;
                try {
                    event.data = r;
                    this.switches.get(i).mouseDown(event);
                    break;
                }
                finally {
                    event.data = savedData;
                }
            }
            ++i;
        }
    }

    private void paintSwitch(Event event, int index, Switch s) {
        Image image;
        if (s == null) {
            this.switchArea.add(null);
            return;
        }
        int x = event.x + this.marginLeft + 16 * index;
        int y = event.y + (WIN32 ? 2 : 3);
        GC gc = event.gc;
        this.switchArea.add(new Rectangle(x, y, 15, 15));
        if (s.hasBorder()) {
            boolean hilighted = (event.detail & 2) != 0;
            boolean focused = ((Control)event.widget).isFocusControl();
            boolean layerSwitch = s instanceof LayerSwitch;
            gc.setLineDash(null);
            gc.setForeground(ColorUtil.switchBorderTopLeft(hilighted, focused, layerSwitch));
            gc.drawLine(x, y, x + 13, y);
            gc.drawLine(x, y, x, y + 13);
            gc.setForeground(ColorUtil.switchBorderBottomRight(hilighted, focused, layerSwitch));
            gc.drawLine(x + 14, y + 1, x + 14, y + 14);
            gc.drawLine(x + 1, y + 14, x + 14, y + 14);
        }
        if ((image = s.getImage()) != null) {
            Rectangle bounds = image.getBounds();
            gc.drawImage(image, x + (15 - bounds.width) / 2, y + (15 - bounds.height) / 2);
        }
    }
}

