/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ReplaceTextAnimatorOperation
extends ProjectOperation {
    private final String compId;
    private final String layerId;
    private final int animatorIndex;
    private final String oldData;
    private final String newData;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    public ReplaceTextAnimatorOperation(ProjectManager pm, TextLayer layer, int animatorIndex, TextAnimator animator) {
        super(pm, "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u306e\u8a2d\u5b9a");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = pm.checkLayer((Layer)layer);
        this.compId = comp.getId();
        this.layerId = layer.getId();
        this.animatorIndex = animatorIndex;
        this.oldData = this.encoder.encodeElement(layer.getTextAnimators().get(animatorIndex));
        this.newData = this.encoder.encodeElement((Object)animator);
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replace(this.newData, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replace(this.oldData, project, pm);
        return Status.OK_STATUS;
    }

    private void replace(String data, Project project, ProjectManager pm) throws ExecutionException {
        TextAnimator animator;
        try {
            animator = (TextAnimator)this.decoder.decodeElement((CharSequence)data, TextAnimator.class);
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding TextAnimator data", (Throwable)e);
        }
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        TextLayer layer = (TextLayer)comp.getLayer(this.layerId);
        layer.getTextAnimators().set(this.animatorIndex, animator);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, String.format("textAnimators[%d]", this.animatorIndex));
        }
    }
}

