/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RenameLayerOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _oldName;
    private final String _newName;

    public RenameLayerOperation(ProjectManager pm, Layer layer, String newName) {
        super(pm, "\u30ec\u30a4\u30e4\u30fc\u540d\u306e\u5909\u66f4");
        LayerComposition comp = pm.checkLayer(layer);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._oldName = layer.getName();
        this._newName = newName;
        this._noEffect = newName.equals(this._oldName);
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setLayerName(this._newName, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setLayerName(this._oldName, project, pm);
        return Status.OK_STATUS;
    }

    private void setLayerName(String name, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        layer.setName(name);
        if (pm != null) {
            pm.fireLayerPropertyChange(layer, "name");
        }
    }
}

