/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RemoveKeyframesOperation
extends ProjectOperation {
    private final String _compId;
    private final Object[][] _data;

    public RemoveKeyframesOperation(ProjectManager projectManager, LayerComposition comp, Object[][] data) {
        super(projectManager, "\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306e\u524a\u9664");
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._data = data;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.removeOrRestore(true, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.removeOrRestore(false, project, pm);
        return Status.OK_STATUS;
    }

    private void removeOrRestore(boolean remove, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Object[][] data = pm != null ? new Object[this._data.length][] : null;
        int i = 0;
        int n = this._data.length;
        while (i < n) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer((String)this._data[i][0]);
            Integer effectIndex = (Integer)this._data[i][1];
            String property = (String)this._data[i][2];
            Keyframe kf = (Keyframe)this._data[i][3];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            if (remove) {
                avalue.removeKeyframe(kf.time);
                if (data != null) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = layer;
                    objectArray[1] = effectIndex;
                    objectArray[2] = property;
                    data[i] = objectArray;
                }
            } else {
                avalue.putKeyframe(kf);
                if (data != null) {
                    data[i] = new Object[]{layer, effectIndex, property, kf.time};
                }
            }
            ++i;
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, data);
        }
    }
}

