/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TARangeSelector;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TAWigglySelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddTASelectorOperation
extends ProjectOperation {
    private final String compId;
    private final String layerId;
    private final int animatorIndex;
    private final String data;
    @Inject
    private ProjectElementFactory elementFactory;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    public AddTASelectorOperation(ProjectManager pm, TextLayer layer, TextAnimator animator, Class<? extends TASelector> selectorClass) {
        super(pm, "\u30bb\u30ec\u30af\u30bf\u306e\u8ffd\u52a0");
        TARangeSelector selector;
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = pm.checkLayer((Layer)layer);
        this.compId = comp.getId();
        this.layerId = layer.getId();
        this.animatorIndex = layer.getTextAnimators().indexOf(animator);
        if (this.animatorIndex == -1) {
            throw new IllegalArgumentException("no such TextAnimator found");
        }
        if (selectorClass == TARangeSelector.class) {
            this.setLabel("\u7bc4\u56f2\u30bb\u30ec\u30af\u30bf\u306e\u8ffd\u52a0");
            selector = this.elementFactory.newTARangeSelector();
        } else if (selectorClass == TAWigglySelector.class) {
            this.setLabel("\u30a6\u30a3\u30b0\u30ea\u30fc\u30bb\u30ec\u30af\u30bf\u306e\u8ffd\u52a0");
            selector = this.elementFactory.newTAWigglySelector();
        } else {
            throw new RuntimeException("unknown TASelector class: " + selectorClass.getName());
        }
        selector.setName(this.uniqueSelectorNames(animator, selector.getName()));
        this.data = this.encoder.encodeElement((Object)selector);
    }

    private String uniqueSelectorNames(TextAnimator animator, String prefix) {
        String name;
        Set names = Util.newSet();
        for (TASelector selector : animator.getSelectors()) {
            names.add(selector.getName());
        }
        int n = 1;
        while (names.contains(name = String.valueOf(prefix) + " " + n++)) {
        }
        return name;
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        TASelector selector;
        try {
            selector = (TASelector)this.decoder.decodeElement((CharSequence)this.data, TASelector.class);
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding TASelector data", (Throwable)e);
        }
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        TextLayer layer = (TextLayer)comp.getLayer(this.layerId);
        TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(this.animatorIndex);
        animator.getSelectors().add(selector);
        if (pm != null) {
            int selectorIndex = animator.getSelectors().size() - 1;
            pm.fireTASelectorsAdd(comp, new Object[][]{{layer, this.animatorIndex, selectorIndex}});
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        TextLayer layer = (TextLayer)comp.getLayer(this.layerId);
        TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(this.animatorIndex);
        int selectorIndex = animator.getSelectors().size() - 1;
        animator.getSelectors().remove(selectorIndex);
        if (pm != null) {
            pm.fireTASelectorsRemove(comp, new Object[][]{{layer, this.animatorIndex, selectorIndex}});
        }
        return Status.OK_STATUS;
    }
}

