/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.player.PlayerLock;
import ch.kuramo.javie.app.player.PlayerThreadEvent;
import ch.kuramo.javie.app.player.PlayerThreadListener;
import ch.kuramo.javie.app.player.TimeKeeper;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.SWT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioThread
extends Thread {
    private static final Logger _logger = LoggerFactory.getLogger(AudioThread.class);
    private static final Mixer.Info _jsaeMixerInfo;
    private final SourceDataLine _playLine;
    private final SourceDataLine _scrubLine;
    private final TimeKeeper _timeKeeper;
    private final MediaItem _mediaItem;
    private final AtomicReference<Time> _newTime = new AtomicReference();
    private final ListenerList _playerThreadListeners = new ListenerList();
    private final Object _monitor = new Object();
    private volatile boolean _playing;
    private volatile boolean _scrubbing;
    private volatile boolean _finished;
    private volatile boolean _muted;
    @Inject
    private RenderContext _context;
    @Inject
    private IArrayPools _arrayPools;

    static {
        Mixer.Info mixerInfo = null;
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
            int n = infoArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mixer.Info mi = infoArray[n2];
                if (mi.getName().equals("Java Sound Audio Engine")) {
                    mixerInfo = mi;
                    break;
                }
                ++n2;
            }
        }
        _jsaeMixerInfo = mixerInfo;
    }

    public AudioThread(MediaItem mediaItem) throws LineUnavailableException {
        super("AudioThread: " + mediaItem.getName());
        this.setPriority(this.getThreadGroup().getMaxPriority());
        MediaInput input = mediaItem.getMediaInput();
        if (input == null) {
            throw new IllegalArgumentException("no MediaInput is available");
        }
        if (!input.isAudioAvailable()) {
            throw new IllegalArgumentException("no audio is available");
        }
        AudioFormat lineFormat = new AudioFormat(48000.0f, 16, 2, true, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, lineFormat);
        this._playLine = (SourceDataLine)AudioSystem.getLine(lineInfo);
        this._playLine.open(lineFormat, lineFormat.getFrameSize() * (int)(lineFormat.getFrameRate() / 10.0f));
        this._scrubLine = _jsaeMixerInfo != null ? AudioSystem.getSourceDataLine(lineFormat, _jsaeMixerInfo) : (SourceDataLine)AudioSystem.getLine(lineInfo);
        this._scrubLine.open(lineFormat, lineFormat.getFrameSize() * (int)(lineFormat.getFrameRate() / 10.0f));
        this._timeKeeper = TimeKeeper.fromAudioLine(this._playLine);
        InjectorHolder.getInjector().injectMembers((Object)this);
        this._mediaItem = mediaItem;
    }

    public TimeKeeper getTimeKeeper() {
        return this._timeKeeper;
    }

    public boolean isMuted() {
        return this._muted;
    }

    public void setMuted(boolean muted) {
        this._muted = muted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            MediaInput input = this._mediaItem.getMediaInput();
            Time duration = input.getDuration();
            AudioMode audioMode = AudioMode.STEREO_48KHZ_INT16;
            int chunkFrames = audioMode.sampleRate / 10;
            Time chunkDuration = Time.fromFrameNumber((long)chunkFrames, (Time)audioMode.sampleDuration);
            Time halfChunkDur = Time.fromFrameNumber((long)(chunkFrames / 2), (Time)audioMode.sampleDuration);
            int chunkBytes = audioMode.frameSize * chunkFrames;
            int one3rdChunkBytes = chunkBytes / 3;
            this._playLine.start();
            this._scrubLine.start();
            this._context.activate();
            Time nextTime = Time.fromFrameNumber((long)0L, (Time)audioMode.sampleDuration);
            while (this.waitForPlaying()) {
                IAudioBuffer ab;
                SourceDataLine line;
                Time time;
                block36: {
                    Object t1;
                    time = this._newTime.getAndSet(null);
                    if (this._scrubbing) {
                        Object object = this._monitor;
                        synchronized (object) {
                            this._playing = false;
                            this._scrubbing = false;
                        }
                        if (time == null) continue;
                        line = this._scrubLine;
                        if (nextTime.timeValue != 0L && line.available() < chunkBytes) {
                            t1 = nextTime.subtract(halfChunkDur);
                            Time t2 = t1.add(chunkDuration);
                            if (!time.before((Time)t1) && time.before(t2)) {
                                time = nextTime;
                            } else if (!time.before((Time)(t1 = t1.subtract(chunkDuration))) && time.before(t2 = t2.subtract(chunkDuration))) {
                                if (line.available() < one3rdChunkBytes) {
                                    continue;
                                }
                            } else if (!time.before(t1.subtract(chunkDuration)) && time.before(t2.subtract(chunkDuration))) {
                                time = nextTime.subtract(chunkDuration).subtract(chunkDuration);
                                if (time.timeValue < 0L) {
                                    time = new Time(0L, time.timeScale);
                                }
                            }
                        }
                        if (!time.before(duration)) {
                            continue;
                        }
                    } else {
                        line = this._playLine;
                        if (time != null) {
                            line.flush();
                            this._timeKeeper.setTime(time);
                        } else {
                            time = nextTime;
                        }
                        if (!time.before(duration)) {
                            line.drain();
                            t1 = this._monitor;
                            synchronized (t1) {
                                this._playing = false;
                            }
                            this.fireThreadEndOfDuration(time);
                            continue;
                        }
                    }
                    ab = null;
                    if (!this._muted) {
                        this._context.reset();
                        this._context.setAudioMode(audioMode);
                        this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                        this._context.setAudioFrameCount(chunkFrames);
                        this._context.setVideoResolution(Resolution.FULL);
                        if (this._mediaItem instanceof CompositionItem) {
                            Composition comp = ((CompositionItem)this._mediaItem).getComposition();
                            this._context.setVideoFrameDuration(comp.getFrameDuration());
                            PlayerLock.readLock().lock();
                            try {
                                try {
                                    comp.prepareExpression(this._context.createInitialExpressionScope(comp));
                                    ab = input.getAudioChunk(time);
                                }
                                catch (Exception e) {
                                    _logger.error("error getting audio chunk", (Throwable)e);
                                    PlayerLock.readLock().unlock();
                                    break block36;
                                }
                            }
                            catch (Throwable throwable) {
                                PlayerLock.readLock().unlock();
                                throw throwable;
                            }
                            PlayerLock.readLock().unlock();
                        } else {
                            try {
                                ab = input.getAudioChunk(time);
                            }
                            catch (Exception e) {
                                _logger.error("error getting audio chunk", (Throwable)e);
                            }
                        }
                    }
                }
                if (ab != null) {
                    this.write(ab, line);
                    ab.dispose();
                } else {
                    this.writeZero(chunkFrames, line);
                }
                nextTime = time.add(Time.fromFrameNumber((long)(ab != null ? ab.getFrameCount() : chunkFrames), (Time)audioMode.sampleDuration));
                this.fireThreadRender(time);
            }
        }
        finally {
            this._context.deactivate();
            this._playLine.close();
            this._scrubLine.close();
        }
    }

    public void setTime(Time time) {
        this._newTime.set(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(boolean play) {
        if (this._playing != play || this._scrubbing) {
            Object object = this._monitor;
            synchronized (object) {
                this._playing = play;
                this._scrubbing = false;
                this._monitor.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrub(Time time) {
        this._newTime.set(time);
        if (!this._playing) {
            Object object = this._monitor;
            synchronized (object) {
                this._playing = true;
                this._scrubbing = true;
                this._monitor.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this._finished) {
            return;
        }
        Object object = this._monitor;
        synchronized (object) {
            this._finished = true;
            this._monitor.notify();
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForPlaying() {
        if (!this._playing) {
            this._playLine.flush();
            Object object = this._monitor;
            synchronized (object) {
                while (!this._finished && !this._playing) {
                    try {
                        this._monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (!this._finished) return true;
        return false;
    }

    private void write(IAudioBuffer ab, SourceDataLine line) {
        double gain = line == this._scrubLine && _jsaeMixerInfo != null ? 2 : 1;
        AudioMode audioMode = ab.getAudioMode();
        int dataLen = ab.getDataLength();
        int lineDataLen = line.getFormat().getFrameSize() * ab.getFrameCount();
        IArray pa = this._arrayPools.getByteArray(lineDataLen);
        byte[] lineBuf = (byte[])pa.getArray();
        switch (audioMode.dataType) {
            case SHORT: {
                short shortVal;
                if (gain == 1.0) {
                    ByteBuffer.wrap(lineBuf, 0, lineDataLen).order(ByteOrder.nativeOrder()).asShortBuffer().put((short[])ab.getData(), 0, dataLen);
                    break;
                }
                Object[] data = (short[])ab.getData();
                int i = 0;
                while (i < dataLen) {
                    shortVal = (short)(Math.min(Math.max((double)data[i] * gain / 32767.0, -1.0), 1.0) * 32767.0);
                    lineBuf[i * 2] = (byte)(shortVal & 0xFF);
                    lineBuf[i * 2 + 1] = (byte)(shortVal >>> 8 & 0xFF);
                    ++i;
                }
                break;
            }
            case INT: {
                short shortVal;
                Object[] data = (int[])ab.getData();
                int i = 0;
                while (i < dataLen) {
                    shortVal = (short)(Math.min(Math.max((double)data[i] * gain / 2.147483647E9, -1.0), 1.0) * 32767.0);
                    lineBuf[i * 2] = (byte)(shortVal & 0xFF);
                    lineBuf[i * 2 + 1] = (byte)(shortVal >>> 8 & 0xFF);
                    ++i;
                }
                break;
            }
            case FLOAT: {
                short shortVal;
                Object[] data = (float[])ab.getData();
                int i = 0;
                while (i < dataLen) {
                    shortVal = (short)(Math.min(Math.max((double)data[i] * gain, -1.0), 1.0) * 32767.0);
                    lineBuf[i * 2] = (byte)(shortVal & 0xFF);
                    lineBuf[i * 2 + 1] = (byte)(shortVal >>> 8 & 0xFF);
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
            }
        }
        if (audioMode.sampleRate == 96000) {
            int i = 0;
            int n = dataLen / 2;
            while (i < n) {
                short s1 = (short)(lineBuf[i * 2 * 2] & 0xFF | (lineBuf[i * 2 * 2 + 1] & 0xFF) << 8);
                short s2 = (short)(lineBuf[i * 2 * 2 + 2] & 0xFF | (lineBuf[i * 2 * 2 + 3] & 0xFF) << 8);
                short s = (short)((s1 + s2) / 2);
                lineBuf[i * 2] = (byte)(s & 0xFF);
                lineBuf[i * 2 + 1] = (byte)(s >>> 8 & 0xFF);
                ++i;
            }
            lineDataLen /= 2;
        }
        line.write(lineBuf, 0, lineDataLen);
        pa.release();
    }

    private void writeZero(int frameCount, SourceDataLine line) {
        IArray pa = this._arrayPools.getByteArray(line.getFormat().getFrameSize() * frameCount);
        pa.clear();
        line.write((byte[])pa.getArray(), 0, pa.getLength());
        pa.release();
    }

    public void addPlayerThreadListener(PlayerThreadListener listener) {
        this._playerThreadListeners.add((Object)listener);
    }

    public void removePlayerThreadListener(PlayerThreadListener listener) {
        this._playerThreadListeners.remove((Object)listener);
    }

    private void fireThreadRender(Time time) {
        PlayerThreadEvent event = new PlayerThreadEvent(this, time);
        Object[] objectArray = this._playerThreadListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerThreadListener)l).threadRender(event);
            ++n2;
        }
    }

    private void fireThreadEndOfDuration(Time time) {
        PlayerThreadEvent event = new PlayerThreadEvent(this, time);
        Object[] objectArray = this._playerThreadListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerThreadListener)l).threadEndOfDuration(event);
            ++n2;
        }
    }
}

