/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.api.plugin.JaviePlugin;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.SplashProgressMonitor;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.EffectRegistry;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ShaderRegistry;
import ch.kuramo.javie.core.services.ShaderRegistryException;
import com.google.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer {
    private static final Logger _logger = LoggerFactory.getLogger(Initializer.class);
    @Inject
    private EffectRegistry _effectRegistry;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ShaderRegistry _shaderRegistry;

    public static void initialize() {
        Initializer initializer = (Initializer)InjectorHolder.getInjector().getInstance(Initializer.class);
        SplashProgressMonitor.subTask("Scanning Core Classes");
        initializer.scanCoreClasses();
        SplashProgressMonitor.worked(1);
        SplashProgressMonitor.subTask("Scanning Extensions");
        initializer.scanExtensions();
        SplashProgressMonitor.worked(1);
        SplashProgressMonitor.subTask("Scanning EzPlugins");
        initializer.scanEasyPlugins();
        SplashProgressMonitor.worked(1);
        SplashProgressMonitor.subTask("");
    }

    Initializer() {
    }

    private void scanCoreClasses() {
        try {
            URL url = FileLocator.resolve((URL)ClasspathUrlFinder.findClassBase(Project.class));
            AnnotationDB db = new AnnotationDB();
            db.scanArchives(new URL[]{url});
            ClassLoader cl = Project.class.getClassLoader();
            this._effectRegistry.searchClasses(db, cl);
            this._elementFactory.searchClasses(db, cl);
            this._shaderRegistry.scanShaders(db, cl);
        }
        catch (IOException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (ShaderRegistryException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private void scanExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("ch.kuramo.javie.api.plugin");
        if (point == null) {
            return;
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block9: {
                    IConfigurationElement cfgElem = iConfigurationElementArray[n4];
                    if ("javie-plugin".equals(cfgElem.getName())) {
                        JaviePlugin plugin;
                        String id = ext.getUniqueIdentifier();
                        String name = ext.getLabel();
                        _logger.info(String.format("loading JaviePlugin: %s [%s]", name, id));
                        SplashProgressMonitor.subTask("Scanning Extension: " + name);
                        try {
                            plugin = (JaviePlugin)cfgElem.createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            _logger.warn("can't load JaviePlugin: " + id, (Throwable)e);
                            break block9;
                        }
                        catch (ClassCastException e) {
                            _logger.warn("can't load JaviePlugin: " + id, (Throwable)e);
                            break block9;
                        }
                        try {
                            Class<?> clazz = plugin.getClass();
                            URL url = FileLocator.resolve((URL)ClasspathUrlFinder.findClassBase(clazz));
                            AnnotationDB db = new AnnotationDB();
                            db.scanArchives(new URL[]{url});
                            ClassLoader cl = clazz.getClassLoader();
                            this._effectRegistry.searchClasses(db, cl);
                            this._elementFactory.searchClasses(db, cl);
                            this._shaderRegistry.scanShaders(db, cl);
                        }
                        catch (Exception e) {
                            _logger.warn("can't load JaviePlugin: " + id, (Throwable)e);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void scanEasyPlugins() {
        File folder;
        String path = System.getProperty("javie.ezplugins.dir");
        if (path == null) {
            if (!new File("Javie.ini").isFile()) {
                return;
            }
            path = SWT.getPlatform().equals("cocoa") ? "../../../ezplugins" : "ezplugins";
        }
        if (!(folder = new File(path)).exists()) {
            _logger.warn("no ezplugins directory found: " + folder.getAbsolutePath());
            return;
        }
        if (!folder.isDirectory()) {
            _logger.warn("path of ezplugins is not directory: " + folder.getAbsolutePath());
            return;
        }
        Object[] jars = folder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        Arrays.sort(jars);
        LinkedHashSet urls = Util.newLinkedHashSet();
        Object[] objectArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            Object jar = objectArray[n2];
            try {
                urls.add(((File)jar).toURI().toURL());
            }
            catch (MalformedURLException e) {
                _logger.warn("can't determine URL of jar file: " + ((File)jar).getAbsolutePath(), (Throwable)e);
            }
            ++n2;
        }
        if (urls.isEmpty()) {
            return;
        }
        ClassLoader parent = this.getClass().getClassLoader();
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        URL[] uRLArray = cl.getURLs();
        int n3 = uRLArray.length;
        int n4 = 0;
        while (n4 < n3) {
            URL url = uRLArray[n4];
            String name = url.getFile();
            int lastSlash = name.lastIndexOf(47);
            if (lastSlash != -1) {
                name = name.substring(lastSlash + 1);
            }
            _logger.info(String.format("loading ezplugin: %s", name));
            SplashProgressMonitor.subTask("Scanning EzPlugin: " + name);
            try {
                AnnotationDB db = new AnnotationDB();
                db.scanArchives(new URL[]{url});
                this._effectRegistry.searchClasses(db, (ClassLoader)cl);
                this._elementFactory.searchClasses(db, (ClassLoader)cl);
                this._shaderRegistry.scanShaders(db, (ClassLoader)cl);
            }
            catch (Exception e) {
                _logger.warn("can't load ezplugin: " + name, (Throwable)e);
            }
            ++n4;
        }
    }
}

