/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.core.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumLabels {
    private static final Map<Class<? extends Enum<?>>, List<String>> labelsMap = Util.newMap();
    private static final Set<Enum<?>> insertSeparator = Util.newSet();

    public static <E extends Enum<E>> String getLabel(E value) {
        Class<?> enumType = value.getClass();
        return EnumLabels.getLabels(enumType).get(value.ordinal());
    }

    public static synchronized <E extends Enum<E>> List<String> getLabels(Class<E> enumType) {
        List<String> list = labelsMap.get(enumType);
        if (list != null) {
            return list;
        }
        Enum[] values = (Enum[])enumType.getEnumConstants();
        String[] labels = new String[values.length];
        int i = 0;
        while (i < values.length) {
            labels[i] = String.valueOf('!') + values[i].name() + '!';
            ++i;
        }
        String baseName = String.valueOf(enumType.getPackage().getName()) + ".messages";
        Locale locale = Locale.getDefault();
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(baseName, locale, enumType.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            try {
                bundle = ResourceBundle.getBundle(baseName, locale);
            }
            catch (MissingResourceException missingResourceException2) {}
        }
        if (bundle != null) {
            int i2 = 0;
            while (i2 < values.length) {
                StringBuilder sb = new StringBuilder();
                Class<Object> c = enumType;
                while (c != null) {
                    sb.insert(0, c.getSimpleName());
                    try {
                        labels[i2] = bundle.getString(String.format("%s.%s", sb.toString(), values[i2].name()));
                    }
                    catch (MissingResourceException missingResourceException) {}
                    try {
                        boolean b = Boolean.valueOf(bundle.getString(String.format("%s.%s.insertSeparator", sb.toString(), values[i2].name())));
                        if (b) {
                            insertSeparator.add(values[i2]);
                        }
                    }
                    catch (MissingResourceException missingResourceException) {}
                    sb.insert(0, '$');
                    c = c.getEnclosingClass();
                }
                ++i2;
            }
        }
        list = Collections.unmodifiableList(Arrays.asList(labels));
        labelsMap.put(enumType, list);
        return list;
    }

    public static <E extends Enum<E>> boolean insertSeparator(E value) {
        EnumLabels.getLabel(value);
        return insertSeparator.contains(value);
    }
}

