/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.output.Output;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.arnx.jsonic.JSON;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchStore {
    private static File getBatchLocation() throws IOException {
        IPath stateLocation = Activator.getDefault().getStateLocation();
        IPath batchLocation = stateLocation.append("batch");
        File file = batchLocation.toFile();
        if (!file.exists()) {
            if (!file.mkdir()) {
                throw new IOException("can't make directory");
            }
        } else if (!file.isDirectory()) {
            throw new IOException("not directory");
        }
        return file;
    }

    private static void writeData(Project project, Output output, String id) throws IOException {
        ProjectEncoder encoder = (ProjectEncoder)InjectorHolder.getInjector().getInstance(ProjectEncoder.class);
        String data = encoder.encodeElement((Object)new Object[]{project, output});
        OutputStreamWriter w = null;
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(BatchStore.getBatchLocation(), id)), "UTF-8");
            w.write(data);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public static Object[] loadData(BatchEntry entry) {
        Object[] objectArray;
        ProjectDecoder decoder = (ProjectDecoder)InjectorHolder.getInjector().getInstance(ProjectDecoder.class);
        File file = new File(BatchStore.getBatchLocation(), entry.id);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            Object[] data = (Object[])decoder.decodeElement((CharSequence)sb.toString(), Object[].class);
            ((Project)data[0]).afterDecode();
            objectArray = data;
        }
        catch (Throwable throwable) {
            try {
                br.close();
                throw throwable;
            }
            catch (ProjectDecodeException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
        }
        br.close();
        return objectArray;
    }

    public static void addBatch(ProjectManager pm, String compItemId, Output output) {
        try {
            File file = pm.getFile();
            String prjName = file != null ? file.getName() : "\u540d\u79f0\u672a\u8a2d\u5b9a\u30d7\u30ed\u30b8\u30a7\u30af\u30c8.jvp";
            String compName = pm.getProject().getItem(compItemId).getName();
            BatchEntry entry = new BatchEntry(prjName, compName, compItemId, output.getFile());
            BatchStore.writeData(pm.getProject(), output, entry.id);
            List<BatchEntry> entries = BatchStore.listEntries();
            entries.add(entry);
            BatchStore.saveEntries(entries);
        }
        catch (IOException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    public static boolean isReserved(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        List<BatchEntry> entries = BatchStore.listEntries();
        for (BatchEntry entry : entries) {
            try {
                if (!entry.file.getCanonicalFile().equals(file)) continue;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static List<BatchEntry> listEntries() {
        List<BatchEntry> list;
        File file = new File(BatchStore.getBatchLocation(), "entries");
        if (!file.exists()) {
            return Util.newList();
        }
        FileInputStream in = new FileInputStream(file);
        try {
            list = ((BatchEntries)JSON.decode((InputStream)in, BatchEntries.class)).entries;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
        }
        in.close();
        return list;
    }

    public static void saveEntries(List<BatchEntry> entries) {
        File tmp = null;
        File bak = null;
        try {
            try {
                File dir = BatchStore.getBatchLocation();
                tmp = File.createTempFile("entries", ".tmp", dir);
                bak = File.createTempFile("entries", ".bak", dir);
                FileOutputStream out = new FileOutputStream(tmp);
                try {
                    JSON.encode((Object)new BatchEntries(entries), (OutputStream)out);
                }
                finally {
                    out.close();
                }
                File file = new File(dir, "entries");
                if (file.exists()) {
                    bak.delete();
                    file.renameTo(bak);
                }
                if (!tmp.renameTo(file)) {
                    throw new IOException(String.format("can't rename %s to %s.", tmp.getName(), file.getName()));
                }
            }
            catch (IOException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
            if (bak != null) {
                bak.delete();
            }
        }
    }

    public static void cleanup() {
        File dir;
        try {
            dir = BatchStore.getBatchLocation();
        }
        catch (IOException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        List<BatchEntry> entries = BatchStore.listEntries();
        List files = Util.newList();
        Iterator<BatchEntry> it = entries.iterator();
        while (it.hasNext()) {
            BatchEntry entry = it.next();
            switch (entry.state) {
                case DONE: 
                case REMOVED: {
                    it.remove();
                    files.add(new File(dir, entry.id));
                    break;
                }
                case IN_PROGRESS: {
                    entry.state = BatchState.ERROR;
                }
            }
        }
        BatchStore.saveEntries(entries);
        for (File file : files) {
            file.delete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BatchEntries {
        public List<BatchEntry> entries;

        public BatchEntries() {
        }

        public BatchEntries(List<BatchEntry> entries) {
            this.entries = entries;
        }
    }

    public static class BatchEntry {
        public String id;
        public BatchState state;
        public String projectName;
        public String compositionName;
        public String compositionItemId;
        public File file;
        public Date registeredTime;
        public Date startTime;
        public Date endTime;

        public BatchEntry() {
        }

        public BatchEntry(String prjName, String compName, String compItemId, File file) {
            this.id = Util.randomId();
            this.state = BatchStore.isReserved(file) ? BatchState.PENDING : BatchState.READY;
            this.projectName = prjName;
            this.compositionName = compName;
            this.compositionItemId = compItemId;
            this.file = file;
            this.registeredTime = new Date();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchState {
        READY,
        IN_PROGRESS,
        CANCELED,
        PENDING,
        ERROR,
        DONE,
        REMOVED;

    }
}

