/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.publisher.eclipse.GeneratorBundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ConfigCUsAction
extends AbstractPublisherAction {
    protected static final String ORG_ECLIPSE_UPDATE_CONFIGURATOR = "org.eclipse.update.configurator";
    private static Collection PROPERTIES_TO_SKIP = new HashSet();
    private static HashSet PROGRAM_ARGS_TO_SKIP;
    protected Version version;
    protected String id;
    protected String flavor;
    IPublisherResult outerResults = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        PROPERTIES_TO_SKIP.add("osgi.frameworkClassPath");
        PROPERTIES_TO_SKIP.add("osgi.framework");
        PROPERTIES_TO_SKIP.add("osgi.bundles");
        PROPERTIES_TO_SKIP.add("eof");
        PROPERTIES_TO_SKIP.add("eclipse.p2.profile");
        PROPERTIES_TO_SKIP.add("eclipse.p2.data.area");
        PROPERTIES_TO_SKIP.add("osgi.launcherPath");
        PROPERTIES_TO_SKIP.add("org.eclipse.update.reconcile");
        PROPERTIES_TO_SKIP.add("org.eclipse.equinox.simpleconfigurator.configUrl");
        PROGRAM_ARGS_TO_SKIP = new HashSet();
        PROGRAM_ARGS_TO_SKIP.add("--launcher.library");
        PROGRAM_ARGS_TO_SKIP.add("-startup");
        PROGRAM_ARGS_TO_SKIP.add("-configuration");
    }

    public static String getAbstractCUCapabilityNamespace(String id, String type, String flavor, String configSpec) {
        return String.valueOf(flavor) + id;
    }

    public static String getAbstractCUCapabilityId(String id, String type, String flavor, String configSpec) {
        return String.valueOf(id) + "." + type;
    }

    public static String computeIUId(String id, String flavor) {
        return String.valueOf(flavor) + id + ".configuration";
    }

    public ConfigCUsAction(IPublisherInfo info, String flavor, String id, Version version) {
        this.flavor = flavor;
        this.id = id;
        this.version = version;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        PublisherResult innerResult = new PublisherResult();
        this.outerResults = results;
        this.info = info;
        String[] configSpecs = info.getConfigurations();
        int i = 0;
        while (i < configSpecs.length) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            String configSpec = configSpecs[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection configAdvice = info.getAdvice(configSpec, false, this.id, this.version, clazz);
            BundleInfo[] bundles = this.fillInBundles(configAdvice, results);
            this.publishBundleCUs(info, bundles, configSpec, innerResult);
            this.publishConfigIUs(configAdvice, innerResult, configSpec);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection launchingAdvice = info.getAdvice(configSpec, false, this.id, this.version, clazz2);
            this.publishIniIUs(launchingAdvice, innerResult, configSpec);
            ++i;
        }
        results.merge(innerResult, 2);
        this.publishTopLevelConfigurationIU(innerResult.getIUs((String)null, "root"), results);
        return Status.OK_STATUS;
    }

    private void publishTopLevelConfigurationIU(Collection children, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription descriptor = this.createParentIU(children, ConfigCUsAction.computeIUId(this.id, this.flavor), this.version);
        descriptor.setSingleton(true);
        IInstallableUnit rootIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        if (rootIU == null) {
            return;
        }
        result.addIU(rootIU, "root");
    }

    private BundleInfo[] fillInBundles(Collection configAdvice, IPublisherResult results) {
        ArrayList<BundleInfo> result = new ArrayList<BundleInfo>();
        Iterator j = configAdvice.iterator();
        while (j.hasNext()) {
            IConfigAdvice advice = (IConfigAdvice)j.next();
            BundleInfo[] bundles = advice.getBundles();
            int i = 0;
            while (i < bundles.length) {
                BundleInfo bundleInfo = bundles[i];
                if (bundleInfo.getSymbolicName() != null && bundleInfo.getVersion() != null || bundleInfo.getLocation() == null) {
                    result.add(bundles[i]);
                } else {
                    try {
                        File location = new File(bundleInfo.getLocation());
                        Dictionary manifest = BundlesAction.loadManifest(location);
                        if (manifest != null) {
                            GeneratorBundleInfo newInfo = new GeneratorBundleInfo(bundleInfo);
                            ManifestElement[] element = ManifestElement.parseHeader((String)"dummy-bsn", (String)((String)manifest.get("Bundle-SymbolicName")));
                            newInfo.setSymbolicName(element[0].getValue());
                            newInfo.setVersion((String)manifest.get("Bundle-Version"));
                            result.add(newInfo);
                        }
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return result.toArray(new BundleInfo[result.size()]);
    }

    private void publishIniIUs(Collection launchingAdvice, IPublisherResult results, String configSpec) {
        if (launchingAdvice.isEmpty()) {
            return;
        }
        String configureData = "";
        String unconfigureData = "";
        if (!launchingAdvice.isEmpty()) {
            String[] dataStrings = this.getLauncherConfigStrings(launchingAdvice);
            configureData = String.valueOf(configureData) + dataStrings[0];
            unconfigureData = String.valueOf(unconfigureData) + dataStrings[1];
        }
        if (configureData.length() == 0 && unconfigureData.length() == 0) {
            return;
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", configureData);
        touchpointData.put("unconfigure", unconfigureData);
        IInstallableUnit cu = this.createCU(this.id, this.version, "ini", this.flavor, configSpec, touchpointData);
        results.addIU(cu, "root");
    }

    private void publishConfigIUs(Collection configAdvice, IPublisherResult results, String configSpec) {
        if (configAdvice.isEmpty()) {
            return;
        }
        String configureData = "";
        String unconfigureData = "";
        if (!configAdvice.isEmpty()) {
            String[] dataStrings = this.getConfigurationStrings(configAdvice);
            configureData = String.valueOf(configureData) + dataStrings[0];
            unconfigureData = String.valueOf(unconfigureData) + dataStrings[1];
        }
        if (configureData.length() == 0 && unconfigureData.length() == 0) {
            return;
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", configureData);
        touchpointData.put("unconfigure", unconfigureData);
        IInstallableUnit cu = this.createCU(this.id, this.version, "config", this.flavor, configSpec, touchpointData);
        results.addIU(cu, "root");
    }

    private IInstallableUnit createCU(String id, Version version, String type, String flavor, String configSpec, Map touchpointData) {
        MetadataFactory.InstallableUnitDescription cu = new MetadataFactory.InstallableUnitDescription();
        String resultId = this.createCUIdString(id, type, flavor, configSpec);
        cu.setId(resultId);
        cu.setVersion(version);
        cu.setFilter(this.createFilterSpec(configSpec));
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        IProvidedCapability selfCapability = PublisherHelper.createSelfCapability(resultId, version);
        String namespace = ConfigCUsAction.getAbstractCUCapabilityNamespace(id, type, flavor, configSpec);
        String abstractId = ConfigCUsAction.getAbstractCUCapabilityId(id, type, flavor, configSpec);
        IProvidedCapability abstractCapability = MetadataFactory.createProvidedCapability((String)namespace, (String)abstractId, (Version)version);
        cu.setCapabilities(new IProvidedCapability[]{selfCapability, abstractCapability});
        cu.addTouchpointData(MetadataFactory.createTouchpointData((Map)touchpointData));
        cu.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    protected String[] getConfigurationStrings(Collection configAdvice) {
        String configurationData = "";
        String unconfigurationData = "";
        HashSet<String> properties = new HashSet<String>();
        Iterator i = configAdvice.iterator();
        while (i.hasNext()) {
            IConfigAdvice advice = (IConfigAdvice)i.next();
            Iterator<Map.Entry<Object, Object>> iterator = advice.getProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> aProperty = iterator.next();
                String key = (String)aProperty.getKey();
                if (!this.shouldPublishProperty(key) || properties.contains(key)) continue;
                properties.add(key);
                configurationData = String.valueOf(configurationData) + "setProgramProperty(propName:" + key + ", propValue:" + (String)aProperty.getValue() + ");";
                unconfigurationData = String.valueOf(unconfigurationData) + "setProgramProperty(propName:" + key + ", propValue:);";
            }
        }
        return new String[]{configurationData, unconfigurationData};
    }

    private boolean shouldPublishProperty(String key) {
        return !PROPERTIES_TO_SKIP.contains(key);
    }

    private boolean shouldPublishJvmArg(String key) {
        return true;
    }

    private boolean shouldPublishProgramArg(String key) {
        return !PROGRAM_ARGS_TO_SKIP.contains(key);
    }

    protected String[] getLauncherConfigStrings(Collection launchingAdvice) {
        String configurationData = "";
        String unconfigurationData = "";
        HashSet<String> jvmSet = new HashSet<String>();
        HashSet<String> programSet = new HashSet<String>();
        Iterator j = launchingAdvice.iterator();
        while (j.hasNext()) {
            IExecutableAdvice advice = (IExecutableAdvice)j.next();
            String[] jvmArgs = advice.getVMArguments();
            int i = 0;
            while (i < jvmArgs.length) {
                if (this.shouldPublishJvmArg(jvmArgs[i]) && !jvmSet.contains(jvmArgs[i])) {
                    jvmSet.add(jvmArgs[i]);
                    configurationData = String.valueOf(configurationData) + "addJvmArg(jvmArg:" + jvmArgs[i] + ");";
                    unconfigurationData = String.valueOf(unconfigurationData) + "removeJvmArg(jvmArg:" + jvmArgs[i] + ");";
                }
                ++i;
            }
            String[] programArgs = advice.getProgramArguments();
            int i2 = 0;
            while (i2 < programArgs.length) {
                if (this.shouldPublishProgramArg(programArgs[i2]) && !programSet.contains(programArgs[i2])) {
                    if (programArgs[i2].startsWith("-")) {
                        programSet.add(programArgs[i2]);
                    }
                    configurationData = String.valueOf(configurationData) + "addProgramArg(programArg:" + programArgs[i2] + ");";
                    unconfigurationData = String.valueOf(unconfigurationData) + "removeProgramArg(programArg:" + programArgs[i2] + ");";
                } else if (i2 + 1 < programArgs.length && !programArgs[i2 + 1].startsWith("-")) {
                    ++i2;
                }
                ++i2;
            }
        }
        return new String[]{configurationData, unconfigurationData};
    }

    protected void publishBundleCUs(IPublisherInfo info, BundleInfo[] bundles, String configSpec, IPublisherResult result) {
        if (bundles == null) {
            return;
        }
        String cuIdPrefix = "";
        String filter = null;
        if (configSpec != null) {
            cuIdPrefix = this.createIdString(configSpec);
            filter = this.createFilterSpec(configSpec);
        }
        int i = 0;
        while (i < bundles.length) {
            block7: {
                GeneratorBundleInfo bundle;
                block9: {
                    block8: {
                        IInstallableUnit iu;
                        bundle = this.createGeneratorBundleInfo(bundles[i], result);
                        if (bundle == null || (iu = bundle.getIU()) == null || !this.filterMatches(iu.getFilter(), configSpec)) break block7;
                        if (!bundle.getSymbolicName().equals(ORG_ECLIPSE_UPDATE_CONFIGURATOR)) break block8;
                        bundle.setStartLevel(-1);
                        bundle.setMarkedAsStarted(false);
                        bundle.setSpecialConfigCommands("setProgramProperty(propName:org.eclipse.update.reconcile, propValue:false);");
                        bundle.setSpecialUnconfigCommands("setProgramProperty(propName:org.eclipse.update.reconcile, propValue:);");
                        break block9;
                    }
                    if (bundle.getStartLevel() == -1 && !bundle.isMarkedAsStarted()) break block7;
                }
                IInstallableUnit cu = null;
                cu = this.version != null && !this.version.equals((Object)Version.emptyVersion) ? BundlesAction.createBundleConfigurationUnit(bundle.getSymbolicName(), this.version, false, bundle, String.valueOf(this.flavor) + cuIdPrefix, filter) : BundlesAction.createBundleConfigurationUnit(bundle.getSymbolicName(), Version.parseVersion((String)bundle.getVersion()), false, bundle, String.valueOf(this.flavor) + cuIdPrefix, filter);
                if (cu != null) {
                    result.addIU(cu, "root");
                }
            }
            ++i;
        }
    }

    protected GeneratorBundleInfo createGeneratorBundleInfo(BundleInfo bundleInfo, IPublisherResult result) {
        String name = bundleInfo.getSymbolicName();
        IInstallableUnit iu = this.queryForIU(this.outerResults, name, Version.create((String)bundleInfo.getVersion()));
        if (iu != null) {
            if (iu.getVersion() == null) {
                bundleInfo.setVersion("0.0.0");
            } else {
                bundleInfo.setVersion(iu.getVersion().toString());
            }
            GeneratorBundleInfo newInfo = new GeneratorBundleInfo(bundleInfo);
            newInfo.setIU(iu);
            return newInfo;
        }
        if (bundleInfo.getLocation() != null || bundleInfo.getVersion() != null) {
            return new GeneratorBundleInfo(bundleInfo);
        }
        int i = name.indexOf(95);
        while (i > -1) {
            try {
                Version bundleVersion = Version.parseVersion((String)name.substring(i));
                bundleInfo.setSymbolicName(name.substring(0, i));
                bundleInfo.setVersion(bundleVersion.toString());
                return new GeneratorBundleInfo(bundleInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                i = name.indexOf(95, i);
            }
        }
        return null;
    }
}

