/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.services.IVBOCache;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.media.opengl.GL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VBOCacheImpl
implements IVBOCache {
    private static final Logger logger = LoggerFactory.getLogger(VBOCacheImpl.class);
    private final ReferenceQueue<Object> refq = new ReferenceQueue();
    private final WeakHashMap<Object, IVBOCache.VBOCacheRecord> cache = new WeakHashMap();
    private final Map<IVBOCache.VBOCacheRecord, VBOCacheReference> refmap = new HashMap<IVBOCache.VBOCacheRecord, VBOCacheReference>();
    private final RenderContext context;

    @Inject
    public VBOCacheImpl(RenderContext context) {
        this.context = context;
    }

    void dispose() {
        for (VBOCacheReference ref : this.refmap.values()) {
            ref.enqueue();
        }
        this.pollAndDelete();
    }

    void pollAndDelete() {
        VBOCacheReference ref;
        GL gl = this.context.getGL();
        int[] vboId = new int[1];
        while ((ref = (VBOCacheReference)this.refq.poll()) != null) {
            if (ref.rec == null) continue;
            this.refmap.remove(ref.rec);
            vboId[0] = ((VBOCacheReference)ref).rec.vboId;
            gl.glDeleteBuffers(1, vboId, 0);
            logger.info("deleted cached vbo");
        }
    }

    public Object put(Object referent, IVBOCache.VBOCacheRecord rec) {
        Object oldData = this.delete(referent);
        this.cache.put(referent, rec);
        this.refmap.put(rec, new VBOCacheReference(referent, rec, this.refq));
        return oldData;
    }

    public IVBOCache.VBOCacheRecord get(Object referent) {
        return this.cache.get(referent);
    }

    public IVBOCache.VBOCacheRecord remove(Object referent) {
        IVBOCache.VBOCacheRecord rec = this.cache.remove(referent);
        VBOCacheReference ref = this.refmap.remove(rec);
        if (ref != null) {
            ref.rec = null;
        }
        return rec;
    }

    public Object delete(Object referent) {
        IVBOCache.VBOCacheRecord rec = this.remove(referent);
        if (rec != null) {
            GL gl = this.context.getGL();
            gl.glDeleteBuffers(1, new int[]{rec.vboId}, 0);
            return rec.data;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VBOCacheReference
    extends PhantomReference<Object> {
        private IVBOCache.VBOCacheRecord rec;

        private VBOCacheReference(Object referent, IVBOCache.VBOCacheRecord rec, ReferenceQueue<Object> q) {
            super(referent, q);
            this.rec = rec;
        }
    }
}

