/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AnimatableBoolean;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TAWigglySelector;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractTASelector;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import noise.ImprovedNoise;

@ProjectElement(value="TAWigglySelector")
public class TAWigglySelectorImpl
extends AbstractTASelector
implements TAWigglySelector {
    private AbstractTASelector.AnimatableMode mode = new AbstractTASelector.AnimatableMode(TASelector.Mode.INTERSECT);
    private AnimatableDouble maxAmount = new AnimatableDouble((Double)100.0, -100.0, 100.0);
    private AnimatableDouble minAmount = new AnimatableDouble((Double)-100.0, -100.0, 100.0);
    private AnimatableDouble wigglesPerSecond = new AnimatableDouble(2.0);
    private AnimatableDouble correlation = new AnimatableDouble((Double)50.0, 0.0, 100.0);
    private AnimatableDouble temporalPhase = new AnimatableDouble(0.0);
    private AnimatableDouble spatialPhase = new AnimatableDouble(0.0);
    private AnimatableBoolean lockDimensions = new AnimatableBoolean(Boolean.FALSE);
    private AnimatableInteger randomSeed = new AnimatableInteger((Integer)0, 0, 10000);
    private final RenderContext context;

    @Inject
    public TAWigglySelectorImpl(RenderContext context) {
        super("\u30a6\u30a3\u30b0\u30ea\u30fc\u30bb\u30ec\u30af\u30bf");
        this.context = context;
    }

    public AbstractTASelector.AnimatableMode getMode() {
        return this.mode;
    }

    public void setMode(AbstractTASelector.AnimatableMode mode) {
        mode.copyConfigurationFrom(this.mode);
        this.mode = mode;
    }

    public AnimatableDouble getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(AnimatableDouble maxAmount) {
        maxAmount.copyConfigurationFrom(this.maxAmount);
        this.maxAmount = maxAmount;
    }

    public AnimatableDouble getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(AnimatableDouble minAmount) {
        minAmount.copyConfigurationFrom(this.minAmount);
        this.minAmount = minAmount;
    }

    public AnimatableDouble getWigglesPerSecond() {
        return this.wigglesPerSecond;
    }

    public void setWigglesPerSecond(AnimatableDouble wigglesPerSecond) {
        wigglesPerSecond.copyConfigurationFrom(this.wigglesPerSecond);
        this.wigglesPerSecond = wigglesPerSecond;
    }

    public AnimatableDouble getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(AnimatableDouble correlation) {
        correlation.copyConfigurationFrom(this.correlation);
        this.correlation = correlation;
    }

    public AnimatableDouble getTemporalPhase() {
        return this.temporalPhase;
    }

    public void setTemporalPhase(AnimatableDouble temporalPhase) {
        temporalPhase.copyConfigurationFrom(this.temporalPhase);
        this.temporalPhase = temporalPhase;
    }

    public AnimatableDouble getSpatialPhase() {
        return this.spatialPhase;
    }

    public void setSpatialPhase(AnimatableDouble spatialPhase) {
        spatialPhase.copyConfigurationFrom(this.spatialPhase);
        this.spatialPhase = spatialPhase;
    }

    public AnimatableBoolean getLockDimensions() {
        return this.lockDimensions;
    }

    public void setLockDimensions(AnimatableBoolean lockDimensions) {
        lockDimensions.copyConfigurationFrom(this.lockDimensions);
        this.lockDimensions = lockDimensions;
    }

    public AnimatableInteger getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(AnimatableInteger randomSeed) {
        randomSeed.copyConfigurationFrom(this.randomSeed);
        this.randomSeed = randomSeed;
    }

    public void prepareExpression(ExpressionScope scope) {
        scope.assignTo(this.mode);
        scope.assignTo(this.maxAmount);
        scope.assignTo(this.minAmount);
        scope.assignTo(this.wigglesPerSecond);
        scope.assignTo(this.correlation);
        scope.assignTo(this.temporalPhase);
        scope.assignTo(this.spatialPhase);
        scope.assignTo(this.lockDimensions);
        scope.assignTo(this.randomSeed);
    }

    public Object createExpressionElement(CoreContext context) {
        return new TAWigglySelectorExpressionElement(context);
    }

    public TASelector.Evaluator createEvaluator(int[] totals, Time mediaTime) {
        final TASelector.Mode mode = (TASelector.Mode)((Object)this.mode.value(this.context));
        final double maxAmount = (Double)this.maxAmount.value(this.context) * 0.01;
        final double minAmount = (Double)this.minAmount.value(this.context) * 0.01;
        double wigglesPerSecond = (Double)this.wigglesPerSecond.value(this.context);
        final double correlation = (Double)this.correlation.value(this.context) * 0.01;
        double temporalPhase = (Double)this.temporalPhase.value(this.context) / 360.0;
        final double spatialPhase = (Double)this.spatialPhase.value(this.context) / 360.0;
        final boolean lockDimensions = (Boolean)this.lockDimensions.value(this.context);
        final int seed = (Integer)this.randomSeed.value(this.context);
        final double time = mediaTime.toSecond() * wigglesPerSecond + temporalPhase;
        int ordinal = this.getBase().ordinal();
        int total = totals[ordinal];
        final double[][] wiggles = new double[total][3];
        int i = 0;
        while (i < wiggles.length) {
            double spatial = ((double)i + 0.5 + (double)total * spatialPhase) * (1.0 - correlation);
            if (lockDimensions) {
                double d = this.amount(this.noise(seed, time, spatial, 113.0), maxAmount, minAmount);
                wiggles[i][2] = d;
                wiggles[i][1] = d;
                wiggles[i][0] = d;
            } else {
                wiggles[i][0] = this.amount(this.noise(seed, time, spatial, 137.0), maxAmount, minAmount);
                wiggles[i][1] = this.amount(this.noise(seed, time, spatial, 73.0), maxAmount, minAmount);
                wiggles[i][2] = this.amount(this.noise(seed, time, spatial, 227.0), maxAmount, minAmount);
            }
            ++i;
        }
        return new AbstractTASelector.AbstractEvaluator(this, totals){

            protected double[] evaluate(double[] combine, int index0, int index1, int total) {
                double[] tvec;
                if (index1 == index0 + 1) {
                    tvec = (double[])wiggles[index0].clone();
                } else {
                    double spatial = ((double)(index0 + index1) * 0.5 + (double)total * spatialPhase) * (1.0 - correlation);
                    if (lockDimensions) {
                        double t = TAWigglySelectorImpl.this.amount(TAWigglySelectorImpl.this.noise(seed, time, spatial, 113.0), maxAmount, minAmount);
                        tvec = new double[]{t, t, t};
                    } else {
                        tvec = new double[]{TAWigglySelectorImpl.this.amount(TAWigglySelectorImpl.this.noise(seed, time, spatial, 137.0), maxAmount, minAmount), TAWigglySelectorImpl.this.amount(TAWigglySelectorImpl.this.noise(seed, time, spatial, 73.0), maxAmount, minAmount), TAWigglySelectorImpl.this.amount(TAWigglySelectorImpl.this.noise(seed, time, spatial, 227.0), maxAmount, minAmount)};
                    }
                }
                return this.applyMode(mode, combine, tvec);
            }
        };
    }

    private double noise(int seed, double arg0, double arg1, double arg2) {
        return ImprovedNoise.noise(arg0 + (double)(seed * 367) + 0.2356, arg1 + (double)(seed * 197) + 0.6049, arg2 + (double)(seed * 271) + 0.7724);
    }

    private double amount(double t, double maxAmount, double minAmount) {
        double max = Math.max(maxAmount, minAmount);
        double min = Math.min(maxAmount, minAmount);
        return (t + 1.0) * 0.5 * (max - min) + min;
    }

    public class TAWigglySelectorExpressionElement
    extends AbstractTASelector.TASelectorExpressionElement {
        public TAWigglySelectorExpressionElement(CoreContext context) {
            super(context);
        }

        public Object getMode() {
            return this.elem(TAWigglySelectorImpl.this.mode);
        }

        public Object getMaxAmount() {
            return this.elem(TAWigglySelectorImpl.this.maxAmount);
        }

        public Object getMinAmount() {
            return this.elem(TAWigglySelectorImpl.this.minAmount);
        }

        public Object getWigglesPerSecond() {
            return this.elem(TAWigglySelectorImpl.this.wigglesPerSecond);
        }

        public Object getCorrelation() {
            return this.elem(TAWigglySelectorImpl.this.correlation);
        }

        public Object getTemporalPhase() {
            return this.elem(TAWigglySelectorImpl.this.temporalPhase);
        }

        public Object getSpatialPhase() {
            return this.elem(TAWigglySelectorImpl.this.spatialPhase);
        }

        public Object getLockDimensions() {
            return this.elem(TAWigglySelectorImpl.this.lockDimensions);
        }

        public Object getRandomSeed() {
            return this.elem(TAWigglySelectorImpl.this.randomSeed);
        }
    }
}

