/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.FrameBlend;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractMediaLayer;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.arnx.jsonic.JSONHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="mediaItemLayer")
public class MediaItemLayerImpl
extends AbstractMediaLayer
implements MediaItemLayer {
    private String _itemId;
    private MediaItem _mediaItem;
    private boolean _videoEnabled;
    private boolean _audioEnabled;
    private boolean _ctcr;
    private FrameBlend _frameBlend = FrameBlend.NONE;
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private VideoEffectPipeline _vePipeline;

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Use initialize(MediaItem) method instead.");
    }

    public void initialize(MediaItem mediaItem) {
        MediaInput input = mediaItem.getMediaInput();
        boolean videoAvailable = input.isVideoAvailable();
        boolean audioAvailable = input.isAudioAvailable();
        if (!videoAvailable && !audioAvailable) {
            throw new IllegalArgumentException("No video nor audio is available.");
        }
        super.initialize();
        this._itemId = mediaItem.getId();
        this._mediaItem = mediaItem;
        this._videoEnabled = videoAvailable;
        this._audioEnabled = audioAvailable;
        this.setName(mediaItem.getName());
    }

    public String getItemId() {
        return this._itemId;
    }

    public void setItemId(String itemId) {
        this._itemId = itemId;
    }

    @Override
    @JSONHint(ignore=true)
    public MediaItem getItem() {
        return this._mediaItem;
    }

    @Override
    @JSONHint(ignore=true)
    public void setItem(MediaItem item) {
        this._itemId = item.getId();
        this._mediaItem = item;
    }

    @Override
    public boolean isVideoEnabled() {
        return this._videoEnabled;
    }

    @Override
    public void setVideoEnabled(boolean enabled) {
        this._videoEnabled = enabled;
    }

    @Override
    public boolean isAudioEnabled() {
        return this._audioEnabled;
    }

    @Override
    public void setAudioEnabled(boolean enabled) {
        this._audioEnabled = enabled;
    }

    @Override
    public boolean isCTCR() {
        return this._ctcr;
    }

    @Override
    public void setCTCR(boolean ctcr) {
        this._ctcr = ctcr;
    }

    @Override
    public FrameBlend getFrameBlend() {
        return this._frameBlend;
    }

    @Override
    public void setFrameBlend(FrameBlend frameBlend) {
        this._frameBlend = frameBlend;
    }

    @Override
    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._mediaItem.getMediaInput();
    }

    @Override
    @JSONHint(ignore=true)
    public boolean isPrecompositionLayer() {
        return this.getPrecomposition() != null;
    }

    private LayerComposition getPrecomposition() {
        Composition comp;
        if (this._mediaItem instanceof CompositionItem && (comp = ((CompositionItem)this._mediaItem).getComposition()) instanceof LayerComposition) {
            return (LayerComposition)comp;
        }
        return null;
    }

    @Override
    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        this._mediaItem = (MediaItem)p.getItem(this._itemId);
        if (this._mediaItem == null) {
            throw new ProjectDecodeException("no such MediaItem found: id=" + this._itemId);
        }
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        ExpressionScope preCompScope;
        super.prepareExpression(scope);
        LayerComposition preComp = this.getPrecomposition();
        if (preComp != null && (preCompScope = scope.createPrecompositionScope(preComp)) != null) {
            preComp.prepareExpression(preCompScope);
        }
    }

    @Override
    public List<VideoLayerRenderer> createCollapsedRenderers() {
        LayerComposition preComp;
        if (LayerNature.isCTCR(this) && (preComp = this.getPrecomposition()) != null) {
            return this.createCollapsedRenderers(preComp);
        }
        throw new IllegalStateException("not collapsed");
    }

    private List<VideoLayerRenderer> createCollapsedRenderers(final LayerComposition preComp) {
        List<VideoLayerRenderer> renderers = this._context.saveAndExecute(new WrappedOperation<List<VideoLayerRenderer>>(){

            @Override
            public List<VideoLayerRenderer> execute() {
                return preComp.createCollapsedRenderers();
            }
        });
        ListIterator<VideoLayerRenderer> it = renderers.listIterator();
        while (it.hasNext()) {
            VideoLayerRenderer r = it.next();
            if (r instanceof VideoLayerRenderer.NormalLayerRenderer) {
                it.set(this.wrapNormalLayerRenderer(preComp, (VideoLayerRenderer.NormalLayerRenderer)r));
                continue;
            }
            if (r instanceof VideoLayerRenderer.CRLayerRenderer) {
                it.set(this.wrapCRLayerRenderer(preComp, (VideoLayerRenderer.CRLayerRenderer)r));
                continue;
            }
            if (r instanceof VideoLayerRenderer.MatteLayerRenderers) {
                this.wrapMatteLayerRenderers(preComp, (VideoLayerRenderer.MatteLayerRenderers)r);
                continue;
            }
            throw new RuntimeException("unsupported VideoLayerRenderer: " + r.getClass().getName());
        }
        return renderers;
    }

    private VideoLayerRenderer.NormalLayerRenderer wrapNormalLayerRenderer(final LayerComposition preComp, final VideoLayerRenderer.NormalLayerRenderer r) {
        return new VideoLayerRenderer.NormalLayerRenderer(){

            @Override
            public MediaLayer getLayer() {
                return r.getLayer();
            }

            @Override
            public void addMatteId(String matteId) {
                r.addMatteId(matteId);
            }

            @Override
            public List<String> getMatteIds() {
                return r.getMatteIds();
            }

            @Override
            public double getOpacity() {
                double opacity = MediaItemLayerImpl.this._context.saveAndExecute(new WrappedOperation<Double>(){

                    @Override
                    public Double execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        return r.getOpacity();
                    }
                });
                return opacity * (Double)MediaItemLayerImpl.this.getOpacity().value(MediaItemLayerImpl.this._context) / 100.0;
            }

            @Override
            public void multModelViewMatrix(final double[] mvMatrix) {
                MediaItemLayerImpl.this._vrSupport.setMatrix(null, mvMatrix);
                LayerMatrixUtil.multModelViewMatrix(MediaItemLayerImpl.this, MediaItemLayerImpl.this._context, MediaItemLayerImpl.this._vrSupport);
                MediaItemLayerImpl.this._vrSupport.getMatrix(null, mvMatrix);
                MediaItemLayerImpl.this._context.saveAndExecute(new WrappedOperation<Object>(){

                    @Override
                    public Object execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        r.multModelViewMatrix(mvMatrix);
                        return null;
                    }
                });
            }

            @Override
            public VideoBounds calcBounds(boolean withEffects) {
                return MediaItemLayerImpl.this._vePipeline.getVideoBounds(MediaItemLayerImpl.this, this.getEffects(withEffects), this.createInputBoundsOperation(withEffects));
            }

            @Override
            public IVideoBuffer render(boolean withEffects, boolean frameBlendEnabled) {
                return MediaItemLayerImpl.this._vePipeline.doVideoEffects(MediaItemLayerImpl.this, this.getEffects(withEffects), this.createInputBoundsOperation(withEffects), this.createInputBufferOperation(withEffects, frameBlendEnabled));
            }

            private List<Effect> getEffects(boolean withEffects) {
                return withEffects && MediaItemLayerImpl.this.isEffectsEnabled() ? MediaItemLayerImpl.this.getEffects() : Collections.emptyList();
            }

            private WrappedOperation<VideoBounds> createInputBoundsOperation(final boolean withEffects) {
                return new WrappedOperation<VideoBounds>(){

                    @Override
                    public VideoBounds execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        return r.calcBounds(withEffects);
                    }
                };
            }

            private WrappedOperation<IVideoBuffer> createInputBufferOperation(final boolean withEffects, final boolean frameBlendEnabled) {
                return new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        return r.render(withEffects, frameBlendEnabled);
                    }
                };
            }
        };
    }

    private VideoLayerRenderer.CRLayerRenderer wrapCRLayerRenderer(final LayerComposition preComp, final VideoLayerRenderer.CRLayerRenderer r) {
        return new VideoLayerRenderer.CRLayerRenderer(){

            @Override
            public MediaLayer getLayer() {
                return r.getLayer();
            }

            @Override
            public void addMatteId(String matteId) {
                r.addMatteId(matteId);
            }

            @Override
            public List<String> getMatteIds() {
                return r.getMatteIds();
            }

            @Override
            public double getOpacity() {
                double opacity = MediaItemLayerImpl.this._context.saveAndExecute(new WrappedOperation<Double>(){

                    @Override
                    public Double execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        return r.getOpacity();
                    }
                });
                return opacity * (Double)MediaItemLayerImpl.this.getOpacity().value(MediaItemLayerImpl.this._context) / 100.0;
            }

            @Override
            public void multModelViewMatrix(final double[] mvMatrix) {
                MediaItemLayerImpl.this._vrSupport.setMatrix(null, mvMatrix);
                LayerMatrixUtil.multModelViewMatrix(MediaItemLayerImpl.this, MediaItemLayerImpl.this._context, MediaItemLayerImpl.this._vrSupport);
                MediaItemLayerImpl.this._vrSupport.getMatrix(null, mvMatrix);
                MediaItemLayerImpl.this._context.saveAndExecute(new WrappedOperation<Object>(){

                    @Override
                    public Object execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        r.multModelViewMatrix(mvMatrix);
                        return null;
                    }
                });
            }

            @Override
            public VideoBounds calcBounds(boolean withEffects, VideoBounds viewport) {
                return MediaItemLayerImpl.this._vePipeline.getVideoBounds(MediaItemLayerImpl.this, this.getEffects(withEffects), this.createInputBoundsOperation(withEffects, viewport));
            }

            @Override
            public IVideoBuffer render(boolean withEffects, VideoBounds viewport, double[] prjMatrix, double[] mvMatrix) {
                return MediaItemLayerImpl.this._vePipeline.doVideoEffects(MediaItemLayerImpl.this, this.getEffects(withEffects), this.createInputBoundsOperation(withEffects, viewport), this.createInputBufferOperation(withEffects, viewport, prjMatrix, mvMatrix));
            }

            @Override
            public IVideoBuffer render() {
                return MediaItemLayerImpl.this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        return r.render();
                    }
                });
            }

            private List<Effect> getEffects(boolean withEffects) {
                return withEffects && MediaItemLayerImpl.this.isEffectsEnabled() ? MediaItemLayerImpl.this.getEffects() : Collections.emptyList();
            }

            private WrappedOperation<VideoBounds> createInputBoundsOperation(final boolean withEffects, final VideoBounds viewport) {
                return new WrappedOperation<VideoBounds>(){

                    @Override
                    public VideoBounds execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        return r.calcBounds(withEffects, viewport);
                    }
                };
            }

            private WrappedOperation<IVideoBuffer> createInputBufferOperation(final boolean withEffects, final VideoBounds viewport, final double[] prjMatrix, final double[] mvMatrix) {
                return new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        MediaItemLayerImpl.this._context.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                        MediaItemLayerImpl.this._context.setComposition(preComp);
                        return r.render(withEffects, viewport, prjMatrix, mvMatrix);
                    }
                };
            }
        };
    }

    private void wrapMatteLayerRenderers(LayerComposition preComp, VideoLayerRenderer.MatteLayerRenderers mlr) {
        ListIterator<VideoLayerRenderer> it = mlr.getRenderers().listIterator();
        while (it.hasNext()) {
            VideoLayerRenderer r = it.next();
            if (r instanceof VideoLayerRenderer.NormalLayerRenderer) {
                it.set(this.wrapNormalLayerRenderer(preComp, (VideoLayerRenderer.NormalLayerRenderer)r));
                continue;
            }
            if (r instanceof VideoLayerRenderer.CRLayerRenderer) {
                it.set(this.wrapCRLayerRenderer(preComp, (VideoLayerRenderer.CRLayerRenderer)r));
                continue;
            }
            if (r instanceof VideoLayerRenderer.MatteLayerRenderers) {
                this.wrapMatteLayerRenderers(preComp, (VideoLayerRenderer.MatteLayerRenderers)r);
                continue;
            }
            throw new RuntimeException("unsupported VideoLayerRenderer: " + r.getClass().getName());
        }
    }
}

