/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

class MediaInputPlaceholderImpl
implements MediaInputPlaceholder {
    private final RenderContext _context;
    private final IVideoRenderSupport _support;
    private VideoBounds videoFrameBounds;

    @Inject
    MediaInputPlaceholderImpl(RenderContext context, IVideoRenderSupport support) {
        this._context = context;
        this._support = support;
    }

    public boolean isAudioAvailable() {
        return false;
    }

    public boolean isVideoAvailable() {
        return true;
    }

    public Time getDuration() {
        return null;
    }

    public Time getVideoFrameDuration() {
        return null;
    }

    public VideoBounds getVideoFrameBounds() {
        if (this.videoFrameBounds != null) {
            return this.videoFrameBounds;
        }
        return new VideoBounds(200, 200);
    }

    void setVideoFrameBounds(VideoBounds videoFrameBounds) {
        this.videoFrameBounds = videoFrameBounds;
    }

    public IAudioBuffer getAudioChunk(Time mediaTime) {
        throw new UnsupportedOperationException("audio is not available");
    }

    public IVideoBuffer getVideoFrame(Time mediaTime) {
        Resolution resolution = this._context.getVideoResolution();
        final VideoBounds bounds = resolution.scale(this.getVideoFrameBounds());
        IVideoBuffer videoBuffer = null;
        try {
            videoBuffer = this._support.createVideoBuffer(bounds);
            Runnable operation = new Runnable(){

                public void run() {
                    float x0 = (float)bounds.x;
                    float y0 = (float)bounds.y;
                    float x1 = (float)(bounds.x + (double)bounds.width);
                    float y1 = (float)(bounds.y + (double)bounds.height);
                    MediaInputPlaceholderImpl.this._support.ortho2D(bounds);
                    GL2 gl = MediaInputPlaceholderImpl.this._context.getGL().getGL2();
                    gl.glClearColor(0.25f, 0.25f, 0.25f, 0.5f);
                    gl.glClear(16384);
                    gl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
                    gl.glLineWidth(2.0f);
                    gl.glBegin(2);
                    gl.glVertex2f(x0, y0);
                    gl.glVertex2f(x1, y0);
                    gl.glVertex2f(x1, y1);
                    gl.glVertex2f(x0, y1);
                    gl.glEnd();
                    gl.glLineWidth(1.0f);
                    gl.glBegin(1);
                    gl.glVertex2f(x0, y0);
                    gl.glVertex2f(x1, y1);
                    gl.glVertex2f(x1, y0);
                    gl.glVertex2f(x0, y1);
                    gl.glEnd();
                }
            };
            int pushAttribs = 16389;
            this._support.useFramebuffer(operation, pushAttribs, videoBuffer, new IVideoBuffer[0]);
            IVideoBuffer result = videoBuffer;
            videoBuffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (videoBuffer != null) {
                videoBuffer.dispose();
            }
        }
    }
}

