/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.effects;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.ColorDepthChanger", category="ch.kuramo.javie.api.effectCategory.utility")
public class ColorDepthChanger {
    @Property
    private IAnimatableEnum<ColorMode> colorDepth;
    private final IVideoEffectContext veContext;
    private final RenderContext renderContext;
    private final IVideoRenderSupport support;

    @Inject
    public ColorDepthChanger(IVideoEffectContext veContext, RenderContext renderContext, IVideoRenderSupport support) {
        this.veContext = veContext;
        this.renderContext = renderContext;
        this.support = support;
    }

    public IVideoBuffer doVideoEffect() {
        ColorMode curColorMode = this.veContext.getColorMode();
        ColorMode newColorMode = (ColorMode)this.veContext.value(this.colorDepth);
        IVideoBuffer source = null;
        IVideoBuffer copy = null;
        try {
            IVideoBuffer result;
            this.renderContext.setColorMode(newColorMode);
            source = this.veContext.doPreviousEffect();
            if (source.getColorMode() != curColorMode) {
                copy = this.support.createVideoBuffer(source.getBounds(), curColorMode);
                this.support.copy(source, copy);
                result = copy;
                copy = null;
            } else {
                result = source;
                source = null;
            }
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            this.renderContext.setColorMode(curColorMode);
            if (source != null) {
                source.dispose();
            }
            if (copy != null) {
                copy.dispose();
            }
        }
    }
}

