/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.expression.ColorProperty;
import ch.kuramo.javie.core.expression.ExpressionUtils;
import java.util.Collection;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableColor
extends ArithmeticalAnimatableValue<Color>
implements IAnimatableColor {
    public AnimatableColor(Color staticValue, Collection<Keyframe<Color>> keyframes, String expression) {
        super(staticValue, keyframes, expression, Color.COLORLESS_TRANSPARENT, Color.WHITE);
    }

    public AnimatableColor(Color defaultValue) {
        super(defaultValue, Color.COLORLESS_TRANSPARENT, Color.WHITE);
    }

    @Override
    public Color clamp(Color value) {
        return value;
    }

    @Override
    public Color jsToJava(Object jsValue) {
        Object o = ExpressionUtils.toDoubleOrDoubleArray(jsValue);
        if (o == null) {
            return Color.BLACK;
        }
        if (o instanceof double[]) {
            double[] array = (double[])o;
            if (array.length < 4) {
                double[] tmp = array;
                array = new double[]{0.0, 0.0, 0.0, 1.0};
                int i = 0;
                while (i < tmp.length) {
                    array[i] = tmp[i];
                    ++i;
                }
            }
            return this.valueOf(array);
        }
        double d = (Double)o;
        return new Color(d, d, d, 1.0);
    }

    @Override
    protected double[] toArray(Color value) {
        return new double[]{value.rawRed, value.rawGreen, value.rawBlue, value.rawAlpha};
    }

    @Override
    protected Color valueOf(double[] d) {
        return new Color(d[0], d[1], d[2], d[3]);
    }

    public Scriptable createExpressionElement(final CoreContext context) {
        ColorProperty cp = new ColorProperty(){

            public Color getValue() {
                return (Color)AnimatableColor.this.value(context);
            }

            public Color valueAtTime(double t) {
                return (Color)AnimatableColor.this.valueAtTime(t, context);
            }
        };
        return context.toNativeJavaObject(cp, null);
    }
}

