/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.ICopyable;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IUPropertyUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.PropertyDialogAction;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.UninstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.UpdateAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.InstalledIUGroup;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.menus.AbstractContributionFactory;

public class InstalledSoftwarePage
extends InstallationPage
implements ICopyable {
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_COLUMN_WIDTH = 150;
    private static final int UPDATE_ID = 1024;
    private static final int UNINSTALL_ID = 1025;
    private static final int PROPERTIES_ID = 1026;
    private static final String BUTTON_ACTION = "org.eclipse.equinox.p2.ui.buttonAction";
    AbstractContributionFactory factory;
    Text detailsArea;
    InstalledIUGroup installedIUGroup;
    String profileId;
    Button updateButton;
    Button uninstallButton;
    Button propertiesButton;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.equinox.p2.ui.installed_software_context");
        this.profileId = Policy.getDefault().getProfileChooser().getProfileId(ProvUI.getDefaultParentShell());
        if (this.profileId == null) {
            IStatus status = Policy.getDefault().getNoProfileChosenStatus();
            if (status != null) {
                ProvUI.reportStatus(status, 1);
            }
            Text text = new Text(parent, 72);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(ProvUIMessages.InstalledSoftwarePage_NoProfile);
            this.setControl((Control)text);
            return;
        }
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.installedIUGroup = new InstalledIUGroup(Policy.getDefault(), composite, JFaceResources.getDialogFont(), this.profileId, this.getColumnConfig());
        CopyUtils.activateCopy(this, this.installedIUGroup.getStructuredViewer().getControl());
        gd = new GridData(4, 4, true, false);
        gd.heightHint = this.convertHeightInCharsToPixels(4);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.detailsArea = new Text(composite, 2890);
        this.detailsArea.setBackground(this.detailsArea.getDisplay().getSystemColor(25));
        this.detailsArea.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public void createPageButtons(Composite parent) {
        if (this.profileId == null) {
            return;
        }
        UpdateAction updateAction = new UpdateAction(Policy.getDefault(), new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer().addSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                StructuredViewer viewer = InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer();
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    Object[] all = ((IStructuredContentProvider)viewer.getContentProvider()).getElements(viewer.getInput());
                    return new StructuredSelection(all);
                }
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer().removeSelectionChangedListener(listener);
            }

            public void setSelection(ISelection selection) {
                InstalledSoftwarePage.this.installedIUGroup.getStructuredViewer().setSelection(selection);
            }
        }, this.profileId, true){

            public void run() {
                super.run();
                if (this.getReturnCode() == 0) {
                    InstalledSoftwarePage.this.getPageContainer().closeModalContainers();
                }
            }
        };
        updateAction.setSkipSelectionPage(true);
        this.updateButton = this.createButton(parent, 1024, updateAction.getText());
        this.updateButton.setData(BUTTON_ACTION, (Object)updateAction);
        UninstallAction uninstallAction = new UninstallAction(Policy.getDefault(), (ISelectionProvider)this.installedIUGroup.getStructuredViewer(), this.profileId){

            public void run() {
                super.run();
                if (this.getReturnCode() == 0) {
                    InstalledSoftwarePage.this.getPageContainer().closeModalContainers();
                }
            }
        };
        this.uninstallButton = this.createButton(parent, 1025, uninstallAction.getText());
        this.uninstallButton.setData(BUTTON_ACTION, (Object)uninstallAction);
        PropertyDialogAction action = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this.installedIUGroup.getStructuredViewer());
        this.propertiesButton = this.createButton(parent, 1026, action.getText());
        this.propertiesButton.setData(BUTTON_ACTION, (Object)action);
        this.installedIUGroup.getStructuredViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InstalledSoftwarePage.this.updateDetailsArea();
                InstalledSoftwarePage.this.updateEnablement();
            }
        });
        this.updateEnablement();
    }

    void updateDetailsArea() {
        String description;
        IInstallableUnit[] selected = this.installedIUGroup.getSelectedIUs();
        if (selected.length == 1 && (description = IUPropertyUtils.getIUProperty(selected[0], "org.eclipse.equinox.p2.description")) != null) {
            this.detailsArea.setText(description);
            return;
        }
        this.detailsArea.setText("");
    }

    void updateEnablement() {
        if (this.updateButton == null || this.updateButton.isDisposed()) {
            return;
        }
        Button[] buttons = new Button[]{this.updateButton, this.uninstallButton, this.propertiesButton};
        int i = 0;
        while (i < buttons.length) {
            Action action = (Action)buttons[i].getData(BUTTON_ACTION);
            if (action == null || !action.isEnabled()) {
                buttons[i].setEnabled(false);
            } else {
                buttons[i].setEnabled(true);
            }
            ++i;
        }
    }

    private IUColumnConfig[] getColumnConfig() {
        int pixels = this.convertHorizontalDLUsToPixels(150);
        return new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, pixels), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, pixels / 3), new IUColumnConfig(ProvUIMessages.ProvUI_IdColumnTitle, 0, pixels * 2 / 3)};
    }

    public void copyToClipboard(Control activeControl) {
        Object[] elements = this.installedIUGroup.getSelectedIUElements();
        if (elements.length == 0) {
            return;
        }
        String text = CopyUtils.getIndentedClipboardText(elements, new IUDetailsLabelProvider(null, this.getColumnConfig(), null));
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                ((Action)this.updateButton.getData(BUTTON_ACTION)).run();
                break;
            }
            case 1025: {
                ((Action)this.uninstallButton.getData(BUTTON_ACTION)).run();
                break;
            }
            case 1026: {
                ((Action)this.propertiesButton.getData(BUTTON_ACTION)).run();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }
}

