/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.noiseGrain.NoiseTexture;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Scatter", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Scatter {
    @Property(min="0", max="1000")
    private IAnimatableDouble scatterAmount;
    @Property
    private IAnimatableEnum<Grain> grain;
    @Property
    private IAnimatableBoolean scatterRandomness;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram[] programs;
    private static final String NOISE_FUNC = "ch.kuramo.javie.effects.noiseGrain.FractalNoise.noise";
    @ShaderSource(attach={"ch.kuramo.javie.effects.noiseGrain.FractalNoise.noise"})
    public static final String[] BOTH = Scatter.createProgramSource(Grain.BOTH);
    @ShaderSource(attach={"ch.kuramo.javie.effects.noiseGrain.FractalNoise.noise"})
    public static final String[] HORIZONTAL = Scatter.createProgramSource(Grain.HORIZONTAL);
    @ShaderSource(attach={"ch.kuramo.javie.effects.noiseGrain.FractalNoise.noise"})
    public static final String[] VERTICAL = Scatter.createProgramSource(Grain.VERTICAL);

    @Inject
    public Scatter(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.programs = new IShaderProgram[3];
        Grain[] grainArray = Grain.values();
        int n = grainArray.length;
        int n2 = 0;
        while (n2 < n) {
            Grain g = grainArray[n2];
            this.programs[g.ordinal()] = shaders.getProgram(Scatter.class, g.name());
            ++n2;
        }
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        final VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        double amount = resolution.scale(((Double)this.context.value((IAnimatableValue)this.scatterAmount)).doubleValue());
        if (amount == 0.0) {
            return source;
        }
        Grain grain = (Grain)((Object)this.context.value(this.grain));
        double random = (double)(this.context.getEffectName().hashCode() % 5023) + ((Boolean)this.context.value((IAnimatableValue)this.scatterRandomness) != false ? this.context.getTime().toSecond() : 0.0);
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("permTexture", 1));
            uniforms.add(new GLUniformData("size", 2, this.toFloatBuffer(bounds.width, bounds.height)));
            uniforms.add(new GLUniformData("amount", (float)amount));
            uniforms.add(new GLUniformData("random", (float)random));
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = Scatter.this.context.getGL().getGL2();
                    int permTexture = NoiseTexture.getPermTexture(gl);
                    gl.glActiveTexture(33985);
                    gl.glBindTexture(3553, permTexture);
                    Scatter.this.support.ortho2D(bounds);
                    Scatter.this.support.quad2D(bounds, (double[][][])new double[0][][]);
                }
            };
            source.setTextureWrapMode(IVideoBuffer.TextureWrapMode.MIRRORED_REPEAT);
            int pushAttribs = 262144;
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.programs[grain.ordinal()], uniforms, operation, pushAttribs, null, new IVideoBuffer[]{source});
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private static String[] createProgramSource(Grain grain) {
        boolean h = grain != Grain.VERTICAL;
        boolean v = grain != Grain.HORIZONTAL;
        return new String[]{h ? "#define HORIZONTAL" : "", v ? "#define VERTICAL" : "", "", "uniform sampler2D texture;", "uniform vec2 size;", "uniform float amount;", "uniform float random;", "", "float noise(vec3 P);", "", "void main(void)", "{", "\tvec2 xy = gl_FragCoord.xy;", "\tfloat nh, nv;", "", "#ifdef HORIZONTAL", "\t\tnh = noise(vec3(xy, random)+vec3(124.543,79.777,267.203));", "#else", "\t\tnh = 0.0;", "#endif", "", "#ifdef VERTICAL", "\t\tnv = noise(vec3(xy, -random)+vec3(91.229,36.791,642.877));", "#else", "\t\tnv = 0.0;", "#endif", "", "\tvec2 tc = (xy + vec2(nh, nv)*amount) / size;", "\tgl_FragColor = texture2D(texture, tc);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Grain {
        BOTH,
        HORIZONTAL,
        VERTICAL;

    }
}

