/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Border", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Border {
    @Property(value="3", min="0", max="50")
    private IAnimatableDouble size;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble softness;
    @Property
    private IAnimatableBoolean borderOnly;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble cutoff;
    @Property
    private IAnimatableEnum<Style> style;
    @Property
    private IAnimatableEnum<Position> position;
    @Property(value="1,0,0")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property(value="true")
    private IAnimatableBoolean accuracy;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final ITexture1DSupport tex1DSupport;
    private final IShaderProgram thresholdProgram;
    private final IShaderProgram outsideProgram;
    private final IShaderProgram outsideBOProgram;
    private final IShaderProgram insideProgram;
    private final IShaderProgram insideBOProgram;
    private final IShaderProgram bothProgram;
    private final IShaderProgram bothBOProgram;
    private static volatile int asinTexture;
    @ShaderSource
    public static final String[] THRESHOLD;
    @ShaderSource
    public static final String[] OUTSIDE;
    @ShaderSource
    public static final String[] OUTSIDE_BORDER_ONLY;
    @ShaderSource
    public static final String[] INSIDE;
    @ShaderSource
    public static final String[] INSIDE_BORDER_ONLY;
    @ShaderSource
    public static final String[] BOTH;
    @ShaderSource
    public static final String[] BOTH_BORDER_ONLY;

    static {
        THRESHOLD = new String[]{"uniform sampler2D texture;", "uniform float cutoff;", "uniform float t_minus_c;", "", "void main(void)", "{", "\tfloat alpha = texture2D(texture, gl_TexCoord[0].st).a;", "\tgl_FragColor = vec4(clamp(alpha-cutoff, 0.0, t_minus_c) / t_minus_c);", "}"};
        OUTSIDE = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform sampler1D asinTexture;", "uniform float threshold;", "uniform float size;", "uniform float softness;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a >= threshold) {", "\t\tgl_FragColor = source + color*(1.0-source.a);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a > 0.00621) {", "\t\t\ta = 1.0+texture1D(asinTexture, a-0.00621).a;", "\t\t\ta = clamp(a*size*(1.0-size*0.01), 0.0, 1.0) * smoothstep(0.0, softness, a);", "\t\t\tgl_FragColor = source + color*(1.0-source.a)*a;", "\t\t} else {", "\t\t\tgl_FragColor = source;", "\t\t}", "\t}", "}"};
        OUTSIDE_BORDER_ONLY = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform sampler1D asinTexture;", "uniform float threshold;", "uniform float size;", "uniform float softness;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a >= threshold) {", "\t\tgl_FragColor = color*(1.0-source.a);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a > 0.00621) {", "\t\t\ta = 1.0+texture1D(asinTexture, a-0.00621).a;", "\t\t\ta = clamp(a*size*(1.0-size*0.01), 0.0, 1.0) * smoothstep(0.0, softness, a);", "\t\t\tgl_FragColor = color*(1.0-source.a)*a;", "\t\t} else {", "\t\t\tgl_FragColor = vec4(0.0);", "\t\t}", "\t}", "}"};
        INSIDE = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform sampler1D asinTexture;", "uniform float threshold;", "uniform float size;", "uniform float softness;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a < threshold) {", "\t\tgl_FragColor = color*(source.a/threshold) + source*(1.0-color.a);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a < 0.99379) {", "\t\t\ta = 1.0-texture1D(asinTexture, a+0.00621).a;", "\t\t\ta = clamp(a*size*(1.0-size*0.01), 0.0, 1.0) * smoothstep(0.0, softness, a);", "\t\t\tgl_FragColor = color*a + source*(1.0-color.a*a);", "\t\t} else {", "\t\t\tgl_FragColor = source;", "\t\t}", "\t}", "}"};
        INSIDE_BORDER_ONLY = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform sampler1D asinTexture;", "uniform float threshold;", "uniform float size;", "uniform float softness;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a < threshold) {", "\t\tgl_FragColor = color*(source.a/threshold);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a < 0.99379) {", "\t\t\ta = 1.0-texture1D(asinTexture, a+0.00621).a;", "\t\t\ta = clamp(a*size*(1.0-size*0.01), 0.0, 1.0) * smoothstep(0.0, softness, a);", "\t\t\tgl_FragColor = color*a;", "\t\t} else {", "\t\t\tgl_FragColor = vec4(0.0);", "\t\t}", "\t}", "}"};
        BOTH = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform sampler1D asinTexture;", "uniform float threshold;", "uniform float size;", "uniform float softness;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\tif (a > 0.00621 && a < 0.99379) {", "\t\tif (a < 0.5) {", "\t\t\ta = 1.0+texture1D(asinTexture, a-0.00621).a;", "\t\t} else {", "\t\t\ta = 1.0-texture1D(asinTexture, a+0.00621).a;", "\t\t}", "\t\ta = clamp(a*size*(1.0-size*0.01), 0.0, 1.0) * smoothstep(0.0, softness, a);", "\t\tgl_FragColor = color*a + source*(1.0-color.a*a);", "\t} else {", "\t\tgl_FragColor = source;", "\t}", "}"};
        BOTH_BORDER_ONLY = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform sampler1D asinTexture;", "uniform float threshold;", "uniform float size;", "uniform float softness;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\tif (a > 0.00621 && a < 0.99379) {", "\t\tif (a < 0.5) {", "\t\t\ta = 1.0+texture1D(asinTexture, a-0.00621).a;", "\t\t} else {", "\t\t\ta = 1.0-texture1D(asinTexture, a+0.00621).a;", "\t\t}", "\t\ta = clamp(a*size*(1.0-size*0.01), 0.0, 1.0) * smoothstep(0.0, softness, a);", "\t\tgl_FragColor = color*a;", "\t} else {", "\t\tgl_FragColor = vec4(0.0);", "\t}", "}"};
    }

    @Inject
    public Border(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, ITexture1DSupport tex1DSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.tex1DSupport = tex1DSupport;
        this.thresholdProgram = shaders.getProgram(Border.class, "THRESHOLD");
        this.outsideProgram = shaders.getProgram(Border.class, "OUTSIDE");
        this.outsideBOProgram = shaders.getProgram(Border.class, "OUTSIDE_BORDER_ONLY");
        this.insideProgram = shaders.getProgram(Border.class, "INSIDE");
        this.insideBOProgram = shaders.getProgram(Border.class, "INSIDE_BORDER_ONLY");
        this.bothProgram = shaders.getProgram(Border.class, "BOTH");
        this.bothBOProgram = shaders.getProgram(Border.class, "BOTH_BORDER_ONLY");
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        Resolution resolution = this.context.getVideoResolution();
        double size = resolution.scale(((Double)this.context.value((IAnimatableValue)this.size)).doubleValue());
        Style style = (Style)((Object)this.context.value(this.style));
        if (size > 0.0) {
            switch (style) {
                case SMOOTH: {
                    return this.blurSupport.calcGaussianBlurredBounds(bounds, size, IBlurSupport.BlurDimensions.BOTH, false);
                }
                case BOX: {
                    return this.blurSupport.calcBoxBlurredBounds(bounds, size, IBlurSupport.BlurDimensions.BOTH, false, 1);
                }
            }
            throw new RuntimeException("unknown Style: " + (Object)((Object)style));
        }
        return bounds;
    }

    public IVideoBuffer doVideoEffect() {
        IShaderProgram program;
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        double threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
        double cutoff = (Double)this.context.value((IAnimatableValue)this.cutoff) / 100.0;
        Style style = (Style)((Object)this.context.value(this.style));
        Position position = (Position)((Object)this.context.value(this.position));
        double size = resolution.scale(((Double)this.context.value((IAnimatableValue)this.size)).doubleValue());
        double softness = (Double)this.context.value((IAnimatableValue)this.softness) / 100.0;
        boolean accuracy = (Boolean)this.context.value((IAnimatableValue)this.accuracy);
        Color color = (Color)this.context.value((IAnimatableValue)this.color);
        double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
        boolean borderOnly = (Boolean)this.context.value((IAnimatableValue)this.borderOnly);
        switch (position) {
            case OUTSIDE: {
                program = borderOnly ? this.outsideBOProgram : this.outsideProgram;
                break;
            }
            case INSIDE: {
                program = borderOnly ? this.insideBOProgram : this.insideProgram;
                break;
            }
            case BOTH: {
                program = borderOnly ? this.bothBOProgram : this.bothProgram;
                break;
            }
            default: {
                throw new RuntimeException("unknown Position: " + (Object)((Object)position));
            }
        }
        IVideoBuffer thresholded = null;
        IVideoBuffer blurred = null;
        IVideoBuffer output = null;
        try {
            HashSet<GLUniformData> uniforms;
            block17: {
                block16: {
                    uniforms = new HashSet<GLUniformData>();
                    uniforms.add(new GLUniformData("texture", 0));
                    uniforms.add(new GLUniformData("cutoff", (float)cutoff));
                    uniforms.add(new GLUniformData("t_minus_c", (float)(threshold - cutoff)));
                    thresholded = this.context.getColorMode().isFloat() || !accuracy || this.context.getQuality() == Quality.DRAFT || resolution.scale < 1.0 ? this.support.createVideoBuffer(source.getBounds()) : this.support.createVideoBuffer(source.getBounds(), ColorMode.RGBA16_FLOAT);
                    this.support.useShaderProgram(this.thresholdProgram, uniforms, thresholded, new IVideoBuffer[]{source});
                    if (!(size > 0.0)) break block16;
                    switch (style) {
                        case SMOOTH: {
                            blurred = this.blurSupport.gaussianBlur(thresholded, size, IBlurSupport.BlurDimensions.BOTH, false, false);
                            break block17;
                        }
                        case BOX: {
                            blurred = this.blurSupport.boxBlur(thresholded, size, IBlurSupport.BlurDimensions.BOTH, false, false, 1);
                            break block17;
                        }
                        default: {
                            throw new RuntimeException("unknown Style: " + (Object)((Object)style));
                        }
                    }
                }
                blurred = thresholded;
            }
            output = this.support.createVideoBuffer(blurred.getBounds());
            final int asinTexture = this.getAsinTexture();
            final IVideoBuffer outbuf = output;
            final IVideoBuffer inbuf0 = blurred;
            final IVideoBuffer inbuf1 = source;
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = Border.this.context.getGL().getGL2();
                    gl.glActiveTexture(33986);
                    gl.glBindTexture(3552, asinTexture);
                    Border.this.support.ortho2D(outbuf);
                    Border.this.support.quad2D(outbuf, new IVideoBuffer[]{inbuf0, inbuf1});
                }
            };
            uniforms.clear();
            uniforms.add(new GLUniformData("texBlurred", 0));
            uniforms.add(new GLUniformData("texSource", 1));
            uniforms.add(new GLUniformData("asinTexture", 2));
            uniforms.add(new GLUniformData("threshold", (float)threshold));
            uniforms.add(new GLUniformData("size", (float)size));
            uniforms.add(new GLUniformData("softness", (float)softness));
            uniforms.add(new GLUniformData("color", 4, this.toFloatBuffer(color.r * opacity, color.g * opacity, color.b * opacity, opacity)));
            int pushAttribs = 262144;
            this.support.useShaderProgram(program, uniforms, operation, pushAttribs, output, new IVideoBuffer[]{blurred, source});
            IVideoBuffer result = output;
            output = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (blurred != null && blurred != thresholded) {
                blurred.dispose();
            }
            if (thresholded != null) {
                thresholded.dispose();
            }
            if (output != null) {
                output.dispose();
            }
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getAsinTexture() {
        if (asinTexture != 0) return asinTexture;
        float[] array = new float[256];
        int i = 0;
        while (i < array.length) {
            double t = (double)i / 255.0;
            array[i] = (float)(Math.asin(2.0 * t - 1.0) * 2.0 / Math.PI);
            ++i;
        }
        Class<Border> clazz = Border.class;
        synchronized (Border.class) {
            if (asinTexture != 0) return asinTexture;
            asinTexture = this.tex1DSupport.texture1DFromArray(array, 6406, 34838);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return asinTexture;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        OUTSIDE,
        INSIDE,
        BOTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        SMOOTH,
        BOX;

    }
}

