/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.OpticsCompensation", category="ch.kuramo.javie.api.effectCategory.distort")
public class OpticsCompensation {
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble amount;
    @Property(value="false")
    private IAnimatableBoolean reverseLensDistortion;
    @Property
    private IAnimatableVec2d viewCenter;
    @Property(value="OFF")
    private IAnimatableEnum<Resize> resize;
    @Property(value="false")
    private IAnimatableBoolean interpolation;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram normalProgram;
    private final IShaderProgram reverseProgram;
    @ShaderSource
    public static final String[] NORMAL_PROGRAM = new String[]{"uniform sampler2D texture;", "uniform vec2 cen_minus_fragOff;", "uniform vec2 cen_minus_texOff;", "uniform float fd;", "uniform float o_div_fd;", "uniform vec2 o_div_ts;", "", "const float PI_0_5 = 3.14159265358979323846264 * 0.5;", "", "void main(void)", "{", "\tvec2 v = gl_FragCoord.xy - cen_minus_fragOff;", "\tfloat d = length(v);", "\tvec2 xy = v/d * fd*tan(clamp(d*o_div_fd, -PI_0_5, PI_0_5)) + cen_minus_texOff;", "\tgl_FragColor = texture2D(texture, xy*o_div_ts);", "}"};
    @ShaderSource
    public static final String[] REVERSE_PROGRAM = new String[]{"uniform sampler2D texture;", "uniform vec2 cen_minus_fragOff;", "uniform vec2 cen_minus_texOff;", "uniform float fd;", "uniform float o_div_fd;", "uniform vec2 o_div_ts;", "", "void main(void)", "{", "\tvec2 v = gl_FragCoord.xy - cen_minus_fragOff;", "\tfloat d = length(v);", "\tvec2 xy = v/d * fd*atan(d*o_div_fd) + cen_minus_texOff;", "\tgl_FragColor = texture2D(texture, xy*o_div_ts);", "}"};

    @Inject
    public OpticsCompensation(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.normalProgram = shaders.getProgram(OpticsCompensation.class, "NORMAL_PROGRAM");
        this.reverseProgram = shaders.getProgram(OpticsCompensation.class, "REVERSE_PROGRAM");
    }

    private double toFocalDistance(double amount) {
        return 500.0 / Math.tan(0.5 * amount * Math.PI);
    }

    private void transformPoint(double[] pt, double focalDistance, Vec2d center) {
        double d = Math.hypot(pt[0], pt[1]);
        if (d > 0.0) {
            double theta = d / focalDistance;
            theta = Math.min(Math.max(theta, -1.5707963267948966), 1.5707963267948966);
            double dd = focalDistance * Math.tan(theta) / d;
            pt[0] = center.x + dd * pt[0];
            pt[1] = center.y + dd * pt[1];
        } else {
            pt[0] = center.x;
            pt[1] = center.y;
        }
    }

    private VideoBounds calcResultBounds(VideoBounds srcBounds, Resize resize, double focalDistance, Vec2d center) {
        double max;
        if (resize == Resize.OFF) {
            return srcBounds;
        }
        double left = srcBounds.x;
        double top = srcBounds.y;
        double right = srcBounds.x + (double)srcBounds.width;
        double bottom = srcBounds.y + (double)srcBounds.height;
        double dLeft = left - center.x;
        double dTop = top - center.y;
        double dRight = right - center.x;
        double dBottom = bottom - center.y;
        double left2 = Double.POSITIVE_INFINITY;
        double top2 = Double.POSITIVE_INFINITY;
        double right2 = Double.NEGATIVE_INFINITY;
        double bottom2 = Double.NEGATIVE_INFINITY;
        double[] pt = new double[]{dLeft, dTop};
        this.transformPoint(pt, focalDistance, center);
        left2 = Math.min(pt[0], left2);
        top2 = Math.min(pt[1], top2);
        pt[0] = dRight;
        pt[1] = dTop;
        this.transformPoint(pt, focalDistance, center);
        right2 = Math.max(pt[0], right2);
        top2 = Math.min(pt[1], top2);
        pt[0] = dRight;
        pt[1] = dBottom;
        this.transformPoint(pt, focalDistance, center);
        right2 = Math.max(pt[0], right2);
        bottom2 = Math.max(pt[1], bottom2);
        pt[0] = dLeft;
        pt[1] = dBottom;
        this.transformPoint(pt, focalDistance, center);
        left2 = Math.min(pt[0], left2);
        bottom2 = Math.max(pt[1], bottom2);
        pt[0] = dLeft;
        pt[1] = 0.0;
        this.transformPoint(pt, focalDistance, center);
        left2 = Math.min(pt[0], left2);
        pt[0] = 0.0;
        pt[1] = dTop;
        this.transformPoint(pt, focalDistance, center);
        top2 = Math.min(pt[1], top2);
        pt[0] = dRight;
        pt[1] = 0.0;
        this.transformPoint(pt, focalDistance, center);
        right2 = Math.max(pt[0], right2);
        pt[0] = 0.0;
        pt[1] = dBottom;
        this.transformPoint(pt, focalDistance, center);
        bottom2 = Math.max(pt[1], bottom2);
        switch (resize) {
            case MAX_2X: {
                max = 2.0;
                break;
            }
            case MAX_4X: {
                max = 4.0;
                break;
            }
            default: {
                max = Double.NaN;
            }
        }
        if (!Double.isNaN(max)) {
            double bottomLimit;
            double topLimit;
            double rightLimit;
            double leftLimit;
            if (dLeft > 0.0) {
                leftLimit = left2;
                rightLimit = left2 + max * (double)srcBounds.width;
            } else if (dRight < 0.0) {
                leftLimit = right2 - max * (double)srcBounds.width;
                rightLimit = right2;
            } else {
                leftLimit = center.x + max * dLeft;
                rightLimit = center.x + max * dRight;
            }
            if (dTop > 0.0) {
                topLimit = top2;
                bottomLimit = top2 + max * (double)srcBounds.height;
            } else if (dBottom < 0.0) {
                topLimit = bottom2 - max * (double)srcBounds.height;
                bottomLimit = bottom2;
            } else {
                topLimit = center.y + max * dTop;
                bottomLimit = center.y + max * dBottom;
            }
            left2 = Math.max(left2, leftLimit);
            top2 = Math.max(top2, topLimit);
            right2 = Math.min(right2, rightLimit);
            bottom2 = Math.min(bottom2, bottomLimit);
        }
        left2 = left - Math.ceil(left - left2);
        top2 = top - Math.ceil(top - top2);
        return new VideoBounds(left2, top2, (int)Math.ceil(right2 - left2), (int)Math.ceil(bottom2 - top2));
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        double amount = (Double)this.context.value((IAnimatableValue)this.amount) / 100.0;
        if (amount == 0.0) {
            return bounds;
        }
        Resolution resolution = this.context.getVideoResolution();
        boolean reverse = (Boolean)this.context.value((IAnimatableValue)this.reverseLensDistortion);
        Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.viewCenter));
        Resize resize = reverse ? (Resize)((Object)this.context.value(this.resize)) : Resize.OFF;
        double focalDistance = this.toFocalDistance(amount);
        return this.calcResultBounds(bounds, resize, focalDistance, center);
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        double amount = (Double)this.context.value((IAnimatableValue)this.amount) / 100.0;
        if (amount == 0.0) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        boolean reverse = (Boolean)this.context.value((IAnimatableValue)this.reverseLensDistortion);
        Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.viewCenter));
        Resize resize = reverse ? (Resize)((Object)this.context.value(this.resize)) : Resize.OFF;
        boolean interpolation = (Boolean)this.context.value((IAnimatableValue)this.interpolation);
        IVideoBuffer.TextureFilter filter = this.context.getQuality() == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (interpolation ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR);
        double focalDistance = this.toFocalDistance(amount);
        VideoBounds resultBounds = this.calcResultBounds(bounds, resize, focalDistance, center);
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(resultBounds);
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("cen_minus_fragOff", 2, this.toFloatBuffer(center.x - resultBounds.x, center.y - resultBounds.y)));
            uniforms.add(new GLUniformData("cen_minus_texOff", 2, this.toFloatBuffer(center.x - bounds.x, center.y - bounds.y)));
            uniforms.add(new GLUniformData("fd", (float)focalDistance));
            uniforms.add(new GLUniformData("o_div_fd", (float)(1.0 / focalDistance)));
            uniforms.add(new GLUniformData("o_div_ts", 2, this.toFloatBuffer(1.0 / (double)bounds.width, 1.0 / (double)bounds.height)));
            source.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER);
            source.setTextureFilter(filter);
            this.support.useShaderProgram(reverse ? this.reverseProgram : this.normalProgram, uniforms, buffer, new IVideoBuffer[]{source});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            if (source != null) {
                source.dispose();
            }
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Resize {
        OFF,
        MAX_2X,
        MAX_4X;

    }
}

