/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.EffectElement;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.app.views.layercomp.TASelectorElement;
import ch.kuramo.javie.app.views.layercomp.TextAnimatorElement;

public class RenameLayerEtcAction extends Action {

	private final LayerCompositionView view;

	private Element element;


	public RenameLayerEtcAction(LayerCompositionView view, Viewer viewer) {
		super("名前の変更");
		this.view = view;

		//setId(CommandIds.RENAME_LAYER_OR_EFFECT);
		//setActionDefinitionId(CommandIds.RENAME_LAYER_OR_EFFECT);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/rename_layer_or_effect.png"));

		updateState(viewer.getSelection());

		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				updateState(event.getSelection());
			}
		});
	}

	private void updateState(ISelection selection) {
		Object obj = null;

		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			if (structuredSelection.size() == 1) {
				obj = structuredSelection.getFirstElement();
			}
		}

		if (obj instanceof LayerElement
				|| obj instanceof EffectElement
				|| obj instanceof TextAnimatorElement
				|| obj instanceof TASelectorElement<?>) {
			setEnabled(true);
			element = (Element) obj;
		} else {
			setEnabled(false);
			element = null;
		}
	}

	public void run() {
		if (element != null) {
			view.editElementName(element);
		}
	}

}
