/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl;

import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.nativewindow.impl.windows.PIXELFORMATDESCRIPTOR;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.windows.wgl.WGLExt;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawableFactory;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsWGLGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    protected static final boolean DEBUG;
    static final String WGL_ARB_pixel_format = "WGL_ARB_pixel_format";
    static final String WGL_ARB_multisample = "WGL_ARB_multisample";
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;
    private PIXELFORMATDESCRIPTOR pixelfmt;
    private int pixelfmtID;
    private GLCapabilitiesChooser chooser;
    private boolean isChosen = false;
    private boolean choosenByARBPixelFormat = false;
    public static final int WINDOW_BIT = 1;
    public static final int BITMAP_BIT = 2;
    public static final int PBUFFER_BIT = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, (CapabilitiesImmutable)gLCapabilitiesImmutable, (CapabilitiesImmutable)gLCapabilitiesImmutable2);
        this.pixelfmt = null;
        this.pixelfmtID = -1;
        this.chooser = gLCapabilitiesChooser;
        this.isChosen = false;
        this.choosenByARBPixelFormat = false;
    }

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n, boolean bl) {
        super(abstractGraphicsScreen, (CapabilitiesImmutable)gLCapabilitiesImmutable, (CapabilitiesImmutable)gLCapabilitiesImmutable2);
        this.setCapsPFD(gLCapabilitiesImmutable, pIXELFORMATDESCRIPTOR, n, bl);
        this.chooser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WindowsWGLGraphicsConfiguration create(GLDrawableFactory gLDrawableFactory, long l, int n, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen, boolean bl, boolean bl2) {
        AbstractGraphicsDevice abstractGraphicsDevice;
        WindowsWGLDrawableFactory windowsWGLDrawableFactory;
        WindowsWGLContext windowsWGLContext;
        if (gLDrawableFactory == null) {
            throw new GLException("Null factory");
        }
        if (l == 0L) {
            throw new GLException("Null HDC");
        }
        if (n <= 0) {
            throw new GLException("Invalid pixelformat id " + n);
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault(abstractGraphicsScreen.getDevice());
        }
        boolean bl3 = null != (windowsWGLContext = (WindowsWGLContext)(windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)gLDrawableFactory).getOrCreateSharedContextImpl(abstractGraphicsDevice = abstractGraphicsScreen.getDevice())) && windowsWGLContext.isExtensionAvailable(WGL_ARB_pixel_format);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = null;
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        if (bl3) {
            windowsWGLContext.makeCurrent();
            try {
                gLCapabilitiesImmutable = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(windowsWGLContext, l, n, gLProfile, bl, bl2);
            }
            finally {
                windowsWGLContext.release();
            }
        } else {
            gLCapabilitiesImmutable = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, l, n, bl, bl2, pIXELFORMATDESCRIPTOR);
        }
        if (null == gLCapabilitiesImmutable) {
            throw new GLException("Couldn't choose Capabilities by: HDC 0x" + Long.toHexString(l) + ", pfdID " + n + ", hasARB " + bl3);
        }
        if (GDI.DescribePixelFormat((long)l, (int)n, (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0) {
            throw new GLException("Unable to describe pixel format " + n);
        }
        return new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable, pIXELFORMATDESCRIPTOR, n, bl3);
    }

    public Object clone() {
        return super.clone();
    }

    public final void updateGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, int[] nArray) {
        WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(this.chooser, gLDrawableFactory, nativeSurface, nArray);
    }

    public final void preselectGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, int[] nArray) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getNativeGraphicsConfiguration().getScreen().getDevice();
        WindowsWGLGraphicsConfigurationFactory.preselectGraphicsConfiguration(this.chooser, gLDrawableFactory, abstractGraphicsDevice, this, nArray);
    }

    final void setCapsPFD(GLCapabilitiesImmutable gLCapabilitiesImmutable, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n, boolean bl) {
        this.pixelfmt = pIXELFORMATDESCRIPTOR;
        this.pixelfmtID = n;
        this.setChosenCapabilities(gLCapabilitiesImmutable);
        this.isChosen = true;
        this.choosenByARBPixelFormat = bl;
        if (DEBUG) {
            System.err.println("*** setCapsPFD: ARB-Choosen " + bl + ", pfdID " + n + ", " + gLCapabilitiesImmutable);
        }
    }

    public final boolean isDetermined() {
        return this.isChosen;
    }

    public final PIXELFORMATDESCRIPTOR getPixelFormat() {
        return this.pixelfmt;
    }

    public final int getPixelFormatID() {
        return this.pixelfmtID;
    }

    public final boolean isChoosenByWGL() {
        return this.choosenByARBPixelFormat;
    }

    static int fillAttribsForGeneralWGLARBQuery(boolean bl, int[] nArray) {
        int n = 0;
        nArray[n++] = 8193;
        nArray[n++] = 8195;
        nArray[n++] = 8208;
        nArray[n++] = 8226;
        nArray[n++] = 8227;
        nArray[n++] = 8209;
        nArray[n++] = 8210;
        nArray[n++] = 8211;
        nArray[n++] = 8213;
        nArray[n++] = 8215;
        nArray[n++] = 8217;
        nArray[n++] = 8219;
        nArray[n++] = 8222;
        nArray[n++] = 8223;
        nArray[n++] = 8224;
        nArray[n++] = 8225;
        if (bl) {
            nArray[n++] = 8257;
            nArray[n++] = 8258;
        }
        return n;
    }

    static boolean wglARBPFIDValid(WindowsWGLContext windowsWGLContext, long l, int n) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = 8212;
        if (!windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l, n, 0, 1, nArray, 0, nArray2, 0)) {
            return GDI.GetLastError() == 0;
        }
        return true;
    }

    static int[] wglAllARBPFIDs(WindowsWGLContext windowsWGLContext, long l) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        WGLExt wGLExt = windowsWGLContext.getWGLExt();
        nArray[0] = 8192;
        if (!wGLExt.wglGetPixelFormatAttribivARB(l, 0, 0, 1, nArray, 0, nArray2, 0)) {
            if (DEBUG) {
                System.err.println("GetPixelFormatAttribivARB: Failed - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int n = nArray2[0];
        if (0 == n) {
            if (DEBUG) {
                System.err.println("GetPixelFormatAttribivARB: No formats - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = 1 + i;
        }
        return nArray3;
    }

    static GLCapabilitiesImmutable wglARBPFID2GLCapabilities(WindowsWGLContext windowsWGLContext, long l, int n, GLProfile gLProfile, boolean bl, boolean bl2) {
        boolean bl3 = windowsWGLContext.isExtensionAvailable(WGL_ARB_pixel_format);
        if (!bl3) {
            return null;
        }
        boolean bl4 = windowsWGLContext.isExtensionAvailable(WGL_ARB_multisample);
        int[] nArray = new int[512];
        int[] nArray2 = new int[512];
        int n2 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(bl4, nArray);
        if (!windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l, n, 0, n2, nArray, 0, nArray2, 0)) {
            throw new GLException("wglARBPFID2GLCapabilities: Error getting pixel format attributes for pixel format " + n + " of device context");
        }
        return WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(gLProfile, nArray, n2, nArray2, bl, bl2);
    }

    static int[] wglChoosePixelFormatARB(long l, WindowsWGLContext windowsWGLContext, GLCapabilitiesImmutable gLCapabilitiesImmutable, int[] nArray, int n, float[] fArray) {
        if (!WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, nArray, windowsWGLContext, n, false, null)) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB1: GLCapabilities2AttribList failed: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[1];
        if (!windowsWGLContext.getWGLExt().wglChoosePixelFormatARB(l, nArray, 0, fArray, 0, 256, nArray2, 0, nArray3, 0)) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB1: wglChoosePixelFormatARB failed: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int n2 = nArray3[0];
        int[] nArray4 = new int[n2];
        System.arraycopy(nArray2, 0, nArray4, 0, n2);
        if (DEBUG) {
            System.err.println("wglChoosePixelFormatARB1: NumFormats (wglChoosePixelFormatARB) accelMode 0x" + Integer.toHexString(n) + ": " + n2);
        }
        return nArray4;
    }

    static GLCapabilitiesImmutable[] wglARBPFIDs2GLCapabilities(WindowsWGLContext windowsWGLContext, long l, int[] nArray, GLProfile gLProfile, boolean bl, boolean bl2) {
        boolean bl3 = windowsWGLContext.isExtensionAvailable(WGL_ARB_pixel_format);
        if (!bl3) {
            return null;
        }
        boolean bl4 = windowsWGLContext.isExtensionAvailable(WGL_ARB_multisample);
        int n = nArray.length;
        GLCapabilitiesImmutable[] gLCapabilitiesImmutableArray = new GLCapabilitiesImmutable[n];
        int[] nArray2 = new int[512];
        int[] nArray3 = new int[512];
        int n2 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(bl4, nArray2);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 1 && windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l, nArray[i], 0, n2, nArray2, 0, nArray3, 0)) {
                gLCapabilitiesImmutableArray[i] = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(gLProfile, nArray2, n2, nArray3, bl, bl2);
                continue;
            }
            if (DEBUG) {
                System.err.println("wglARBPFIDs2GLCapabilities: Cannot get pixel format attributes for pixel format " + i + "/" + n + ": " + nArray[i]);
            }
            gLCapabilitiesImmutableArray[i] = null;
        }
        return gLCapabilitiesImmutableArray;
    }

    static GLCapabilitiesImmutable[] wglARBAllPFIDs2GLCapabilities(WindowsWGLContext windowsWGLContext, long l, GLProfile gLProfile, boolean bl, boolean bl2, int[] nArray) {
        boolean bl3 = windowsWGLContext.isExtensionAvailable(WGL_ARB_pixel_format);
        if (!bl3) {
            return null;
        }
        boolean bl4 = windowsWGLContext.isExtensionAvailable(WGL_ARB_multisample);
        GLCapabilitiesImmutable[] gLCapabilitiesImmutableArray = null;
        int n = 0;
        int n2 = 0;
        int[] nArray2 = new int[512];
        int[] nArray3 = new int[512];
        WGLExt wGLExt = windowsWGLContext.getWGLExt();
        nArray2[0] = 8192;
        if (wGLExt.wglGetPixelFormatAttribivARB(l, 0, 0, 1, nArray2, 0, nArray3, 0)) {
            n = nArray3[0];
            if (DEBUG) {
                System.err.println("wglARBAllPFIDs2GLCapabilities: wglGetPixelFormatAttribivARB reported WGL_NUMBER_PIXEL_FORMATS = " + n + ", pfIDs sz " + nArray.length);
            }
            if (n > nArray.length) {
                n = nArray.length;
            }
            n2 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(bl4, nArray2);
            gLCapabilitiesImmutableArray = new GLCapabilitiesImmutable[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i + 1;
                if (!wGLExt.wglGetPixelFormatAttribivARB(l, nArray[i], 0, n2, nArray2, 0, nArray3, 0)) {
                    throw new GLException("wglARBAllPFIDs2GLCapabilities: Error getting pixel format attributes for pixel format " + nArray[i]);
                }
                gLCapabilitiesImmutableArray[i] = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(gLProfile, nArray2, n2, nArray3, bl, bl2);
            }
        } else {
            long l2 = GDI.GetLastError();
            if (l2 != 0L) {
                throw new GLException("wglARBAllPFIDs2GLCapabilities: Unable to enumerate pixel formats of window using wglGetPixelFormatAttribivARB: error code " + l2);
            }
        }
        return gLCapabilitiesImmutableArray;
    }

    static boolean GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable, int[] nArray, GLContextImpl gLContextImpl, int n, boolean bl, int[] nArray2) throws GLException {
        boolean bl2 = gLContextImpl.isExtensionAvailable(WGL_ARB_pixel_format);
        boolean bl3 = gLContextImpl.isExtensionAvailable(WGL_ARB_multisample);
        if (DEBUG) {
            System.err.println("HDC2GLCapabilities: ARB_pixel_format: " + bl2);
            System.err.println("HDC2GLCapabilities: ARB_multisample : " + bl3);
        }
        if (!bl2) {
            return false;
        }
        int n2 = 0;
        nArray[n2++] = 8208;
        nArray[n2++] = 1;
        if (n > 0) {
            nArray[n2++] = 8195;
            nArray[n2++] = n;
        }
        if (bl) {
            nArray[n2++] = 8237;
            nArray[n2++] = 1;
        } else {
            nArray[n2++] = 8193;
            nArray[n2++] = 1;
        }
        nArray[n2++] = 8209;
        nArray[n2++] = gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0;
        nArray[n2++] = 8210;
        nArray[n2++] = gLCapabilitiesImmutable.getStereo() ? 1 : 0;
        nArray[n2++] = 8226;
        nArray[n2++] = gLCapabilitiesImmutable.getDepthBits();
        nArray[n2++] = 8213;
        nArray[n2++] = gLCapabilitiesImmutable.getRedBits();
        nArray[n2++] = 8215;
        nArray[n2++] = gLCapabilitiesImmutable.getGreenBits();
        nArray[n2++] = 8217;
        nArray[n2++] = gLCapabilitiesImmutable.getBlueBits();
        nArray[n2++] = 8219;
        nArray[n2++] = gLCapabilitiesImmutable.getAlphaBits();
        nArray[n2++] = 8227;
        nArray[n2++] = gLCapabilitiesImmutable.getStencilBits();
        if (gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0 || gLCapabilitiesImmutable.getAccumAlphaBits() > 0) {
            nArray[n2++] = 8221;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits();
            nArray[n2++] = 8222;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumRedBits();
            nArray[n2++] = 8223;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumGreenBits();
            nArray[n2++] = 8224;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumBlueBits();
            nArray[n2++] = 8225;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumAlphaBits();
        }
        if (gLCapabilitiesImmutable.getSampleBuffers() && bl3) {
            nArray[n2++] = 8257;
            nArray[n2++] = 1;
            nArray[n2++] = 8258;
            nArray[n2++] = gLCapabilitiesImmutable.getNumSamples();
        }
        boolean bl4 = gLCapabilitiesImmutable.getPbufferRenderToTexture();
        boolean bl5 = gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle();
        boolean bl6 = gLCapabilitiesImmutable.getPbufferFloatingPointBuffers();
        boolean bl7 = false;
        if (bl) {
            if (bl5 && !bl4) {
                throw new GLException("Render-to-texture-rectangle requires render-to-texture to be specified");
            }
            if (bl5 && !gLContextImpl.isExtensionAvailable("GL_NV_texture_rectangle")) {
                throw new GLException("Render-to-texture-rectangle requires GL_NV_texture_rectangle extension");
            }
            if (bl6) {
                if (!gLContextImpl.isExtensionAvailable("WGL_ATI_pixel_format_float") && !gLContextImpl.isExtensionAvailable("WGL_NV_float_buffer")) {
                    throw new GLException("Floating-point pbuffers not supported by this hardware");
                }
                if (gLContextImpl.isExtensionAvailable("WGL_NV_float_buffer")) {
                    bl7 = false;
                    nArray2[0] = 3;
                } else {
                    bl7 = true;
                    nArray2[0] = 2;
                }
                if (DEBUG) {
                    System.err.println("Using " + (bl7 ? "ATI" : "NVidia") + " floating-point extension");
                }
            }
            if (bl6 && bl7) {
                if (bl4) {
                    throw new GLException("Render-to-floating-point-texture not supported on ATI hardware");
                }
                nArray[n2++] = 8211;
                nArray[n2++] = 8608;
            } else if (!bl4) {
                nArray[n2++] = 8211;
                nArray[n2++] = 8235;
            }
            if (bl6 && !bl7) {
                nArray[n2++] = 8368;
                nArray[n2++] = 1;
            }
            if (bl4) {
                if (bl6) {
                    if (!$assertionsDisabled && bl7) {
                        throw new AssertionError();
                    }
                    if (!bl5) {
                        throw new GLException("Render-to-floating-point-texture only supported on NVidia hardware with render-to-texture-rectangle");
                    }
                    nArray[n2++] = 8371;
                    nArray[n2++] = 1;
                } else {
                    nArray[n2++] = bl5 ? 8352 : 8304;
                    nArray[n2++] = 1;
                }
            }
        } else {
            nArray[n2++] = 8211;
            nArray[n2++] = 8235;
        }
        nArray[n2++] = 0;
        return true;
    }

    static int WGLConfig2DrawableTypeBits(int[] nArray, int n, int[] nArray2) {
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            switch (n3) {
                case 8193: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 1;
                    continue block5;
                }
                case 8194: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 2;
                    continue block5;
                }
                case 8237: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 4;
                }
            }
        }
        return n2;
    }

    static boolean WGLConfigDrawableTypeVerify(int n, boolean bl, boolean bl2) {
        boolean bl3 = bl ? 0 != (n & 1) : (bl2 ? 0 != (n & 4) : 0 != (n & 2));
        return bl3;
    }

    static GLCapabilitiesImmutable AttribList2GLCapabilities(GLProfile gLProfile, int[] nArray, int n, int[] nArray2, boolean bl, boolean bl2) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        int n2 = WindowsWGLGraphicsConfiguration.WGLConfig2DrawableTypeBits(nArray, n, nArray2);
        if (!WindowsWGLGraphicsConfiguration.WGLConfigDrawableTypeVerify(n2, bl, bl2)) {
            if (DEBUG) {
                System.err.println("WGL DrawableType does not match: req(onscrn " + bl + ", pbuffer " + bl2 + "), got(onscreen " + (0 != (n2 & 1)) + ", pbuffer " + (0 != (n2 & 4)) + ", pixmap " + (0 != (n2 & 2)) + ")");
            }
            return null;
        }
        gLCapabilities.setOnscreen(bl);
        gLCapabilities.setPBuffer(bl2);
        block21: for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            switch (n3) {
                case 8193: 
                case 8194: 
                case 8237: {
                    continue block21;
                }
                case 8195: {
                    gLCapabilities.setHardwareAccelerated(nArray2[i] == 8231);
                    continue block21;
                }
                case 8208: {
                    if (nArray2[i] == 1) continue block21;
                    return null;
                }
                case 8226: {
                    gLCapabilities.setDepthBits(nArray2[i]);
                    continue block21;
                }
                case 8227: {
                    gLCapabilities.setStencilBits(nArray2[i]);
                    continue block21;
                }
                case 8209: {
                    gLCapabilities.setDoubleBuffered(nArray2[i] == 1);
                    continue block21;
                }
                case 8210: {
                    gLCapabilities.setStereo(nArray2[i] == 1);
                    continue block21;
                }
                case 8211: {
                    if (nArray2[i] != 8235 && nArray2[i] != 8608) continue block21;
                    gLCapabilities.setPbufferFloatingPointBuffers(true);
                    continue block21;
                }
                case 8368: {
                    if (nArray2[i] == 0) continue block21;
                    gLCapabilities.setPbufferFloatingPointBuffers(true);
                    continue block21;
                }
                case 8213: {
                    gLCapabilities.setRedBits(nArray2[i]);
                    continue block21;
                }
                case 8215: {
                    gLCapabilities.setGreenBits(nArray2[i]);
                    continue block21;
                }
                case 8217: {
                    gLCapabilities.setBlueBits(nArray2[i]);
                    continue block21;
                }
                case 8219: {
                    gLCapabilities.setAlphaBits(nArray2[i]);
                    continue block21;
                }
                case 8222: {
                    gLCapabilities.setAccumRedBits(nArray2[i]);
                    continue block21;
                }
                case 8223: {
                    gLCapabilities.setAccumGreenBits(nArray2[i]);
                    continue block21;
                }
                case 8224: {
                    gLCapabilities.setAccumBlueBits(nArray2[i]);
                    continue block21;
                }
                case 8225: {
                    gLCapabilities.setAccumAlphaBits(nArray2[i]);
                    continue block21;
                }
                case 8257: {
                    gLCapabilities.setSampleBuffers(nArray2[i] != 0);
                    continue block21;
                }
                case 8258: {
                    gLCapabilities.setNumSamples(nArray2[i]);
                    continue block21;
                }
                default: {
                    throw new GLException("Unknown pixel format attribute " + nArray[i]);
                }
            }
        }
        return gLCapabilities;
    }

    static int[] wglAllGDIPFIDs(long l) {
        int n = GDI.DescribePixelFormat((long)l, (int)1, (int)0, null);
        if (n == 0) {
            throw new GLException("DescribePixelFormat: No formats - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1 + i;
        }
        return nArray;
    }

    static GLCapabilitiesImmutable PFD2GLCapabilities(GLProfile gLProfile, long l, int n, boolean bl, boolean bl2, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        if (GDI.DescribePixelFormat((long)l, (int)n, (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0) {
            throw new GLException("Error describing pixel format " + n + " of device context");
        }
        return WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, pIXELFORMATDESCRIPTOR, bl, bl2);
    }

    static GLCapabilitiesImmutable PFD2GLCapabilities(GLProfile gLProfile, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, boolean bl, boolean bl2) {
        if ((pIXELFORMATDESCRIPTOR.getDwFlags() & 0x20) == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(pIXELFORMATDESCRIPTOR.getCRedBits());
        gLCapabilities.setGreenBits(pIXELFORMATDESCRIPTOR.getCGreenBits());
        gLCapabilities.setBlueBits(pIXELFORMATDESCRIPTOR.getCBlueBits());
        gLCapabilities.setAlphaBits(pIXELFORMATDESCRIPTOR.getCAlphaBits());
        gLCapabilities.setAccumRedBits(pIXELFORMATDESCRIPTOR.getCAccumRedBits());
        gLCapabilities.setAccumGreenBits(pIXELFORMATDESCRIPTOR.getCAccumGreenBits());
        gLCapabilities.setAccumBlueBits(pIXELFORMATDESCRIPTOR.getCAccumBlueBits());
        gLCapabilities.setAccumAlphaBits(pIXELFORMATDESCRIPTOR.getCAccumAlphaBits());
        gLCapabilities.setDepthBits(pIXELFORMATDESCRIPTOR.getCDepthBits());
        gLCapabilities.setStencilBits(pIXELFORMATDESCRIPTOR.getCStencilBits());
        gLCapabilities.setDoubleBuffered((pIXELFORMATDESCRIPTOR.getDwFlags() & 1) != 0);
        gLCapabilities.setStereo((pIXELFORMATDESCRIPTOR.getDwFlags() & 2) != 0);
        gLCapabilities.setHardwareAccelerated((pIXELFORMATDESCRIPTOR.getDwFlags() & 0x40) == 0 || (pIXELFORMATDESCRIPTOR.getDwFlags() & 0x1000) != 0);
        gLCapabilities.setOnscreen(bl && (pIXELFORMATDESCRIPTOR.getDwFlags() & 4) != 0);
        gLCapabilities.setPBuffer(bl2);
        return gLCapabilities;
    }

    static PIXELFORMATDESCRIPTOR GLCapabilities2PFD(GLCapabilitiesImmutable gLCapabilitiesImmutable, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        int n = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        if (n < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int n2 = 4128;
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            n2 |= 1;
        }
        n2 = gLCapabilitiesImmutable.isOnscreen() ? (n2 |= 4) : (n2 |= 8);
        if (gLCapabilitiesImmutable.getStereo()) {
            n2 |= 2;
        }
        pIXELFORMATDESCRIPTOR.setDwFlags(n2);
        pIXELFORMATDESCRIPTOR.setIPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.setCColorBits((byte)n);
        pIXELFORMATDESCRIPTOR.setCRedBits((byte)gLCapabilitiesImmutable.getRedBits());
        pIXELFORMATDESCRIPTOR.setCGreenBits((byte)gLCapabilitiesImmutable.getGreenBits());
        pIXELFORMATDESCRIPTOR.setCBlueBits((byte)gLCapabilitiesImmutable.getBlueBits());
        pIXELFORMATDESCRIPTOR.setCAlphaBits((byte)gLCapabilitiesImmutable.getAlphaBits());
        int n3 = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits();
        pIXELFORMATDESCRIPTOR.setCAccumBits((byte)n3);
        pIXELFORMATDESCRIPTOR.setCAccumRedBits((byte)gLCapabilitiesImmutable.getAccumRedBits());
        pIXELFORMATDESCRIPTOR.setCAccumGreenBits((byte)gLCapabilitiesImmutable.getAccumGreenBits());
        pIXELFORMATDESCRIPTOR.setCAccumBlueBits((byte)gLCapabilitiesImmutable.getAccumBlueBits());
        pIXELFORMATDESCRIPTOR.setCAccumAlphaBits((byte)gLCapabilitiesImmutable.getAccumAlphaBits());
        pIXELFORMATDESCRIPTOR.setCDepthBits((byte)gLCapabilitiesImmutable.getDepthBits());
        pIXELFORMATDESCRIPTOR.setCStencilBits((byte)gLCapabilitiesImmutable.getStencilBits());
        pIXELFORMATDESCRIPTOR.setILayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor() {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.create();
        pIXELFORMATDESCRIPTOR.setNSize((short)pIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.setNVersion((short)1);
        return pIXELFORMATDESCRIPTOR;
    }

    public String toString() {
        return "WindowsWGLGraphicsConfiguration[" + this.getScreen() + ", pfdID " + this.pixelfmtID + ", ARB-Choosen " + this.choosenByARBPixelFormat + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }

    static {
        $assertionsDisabled = !WindowsWGLGraphicsConfiguration.class.desiredAssertionStatus();
        DEBUG = Debug.debug("GraphicsConfiguration");
    }
}

