/*
 * Copyright (c) 2009-2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.List;

import ch.kuramo.javie.core.TextAnimator.AnchorPointGrouping;
import ch.kuramo.javie.core.TextAnimator.CharacterAlignment;

public interface TextLayer extends MediaLayer {

	boolean isCTCR();

	void setCTCR(boolean ctcr);


	AnimatableString getSourceText();

	AnimatableString getFont();

	AnimatableInteger getFontSize();


	TextType getTextType();

	void setTextType(TextType textType);


	AnimatableColor getFillColor();

	AnimatableColor getStrokeColor();

	AnimatableDouble getStrokeWidth();

	AnimatableEnum<LineJoin> getLineJoin();

	AnimatableDouble getMiterLimit();

	AnimatableEnum<OrderOfFillAndStroke> getOrderOfFillAndStroke();


	AnimatableEnum<HorizontalAlignment> getHorizontalAlignment();

	AnimatableDouble getTracking();

	AnimatableDouble getLeading();


	AnimatableEnum<AnchorPointGrouping> getAnchorPointGrouping();

	AnimatableVec2d getGroupingAlignment();

	AnimatableEnum<CharacterAlignment> getCharacterAlignment();

	List<TextAnimator> getTextAnimators();

	boolean isPerCharacter3D();

	void setPerCharacter3D(boolean perCharacter3D);


	List<VideoLayerRenderer> createPerCharacter3DRenderers();


	public enum TextType { FILL_ONLY, STROKE_ONLY, FILL_AND_STROKE /*, EXTRUDED*/ }

	public enum LineJoin { MITER, ROUND, BEVEL }

	public enum OrderOfFillAndStroke { STROKE_OVER_FILL, FILL_OVER_STROKE, ALL_STROKES_OVER_ALL_FILLS, ALL_FILLS_OVER_ALL_STROKES }

	public enum HorizontalAlignment { LEFT, CENTER, RIGHT }

}
