/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.List;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableEnum;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.TextLayer.OrderOfFillAndStroke;
import ch.kuramo.javie.core.TextLayer.TextType;

public class TextTypeElement extends LayerEnumPropertyElement.ForSimpleProperty<TextType> {

	private TextType type;

	private final List<Element> children = Util.newList();


	public TextTypeElement(TextElement parent) {
		super(parent, parent.getLayer(), "textType", "塗りと線", "塗りと線を変更");
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		TextType currentType = getValue();

		if (currentType == type && children.size() > 0) {
			return children.toArray(new Element[children.size()]);
		}

		children.clear();
		type = currentType;

		if (type == TextType.FILL_ONLY || type == TextType.FILL_AND_STROKE /*|| type == TextType.EXTRUDED*/) {
			createAnimatableValueElement("fillColor", "塗りのカラー");
		}

		if (type == TextType.STROKE_ONLY || type == TextType.FILL_AND_STROKE) {
			createAnimatableValueElement("strokeColor", "線のカラー");
			createAnimatableValueElement("strokeWidth", "線の幅", "px");
			createAnimatableValueElement("lineJoin", "線の結合");
			createMiterLimitElement("miterLimit", "マイターリミット");
		}

		if (type == TextType.FILL_AND_STROKE) {
			createOrderOfFillAndStroke("orderOfFillAndStroke", "塗りと線の順序");
		}

		//if (type == TextType.EXTRUDED) {
		//	createAnimatableValueElement("extrusionDepth", "厚さ");
		//}

		return children.toArray(new Element[children.size()]);
	}

	private void createAnimatableValueElement(String property, String name) {
		children.add(LayerAnimatableValueElement.forSimpleProperty(this, layer, property, name, null));
	}

	private void createAnimatableValueElement(String property, String name, String unit) {
		children.add(LayerAnimatableValueElement.forSimpleProperty(this, layer, property, name, unit));
	}

	private void createMiterLimitElement(String property, String name) {
		children.add(new LayerAnimatableValueElement.ForSimpleProperty(this, layer, property, name) {
			protected AnimatableValueElementDelegate<?> createDelegate() {
				AnimatableDouble avalue = PropertyUtil.getProperty(layer, getProperty());
				return new AnimatableDoubleElementDelegate(this, name, avalue, 0.1, 1, 4, unit);
			}
		});
	}

	private void createOrderOfFillAndStroke(String property, String name) {
		children.add(new LayerAnimatableValueElement.ForSimpleProperty(this, layer, property, name) {
			protected AnimatableValueElementDelegate<?> createDelegate() {
				AnimatableEnum<OrderOfFillAndStroke> avalue = PropertyUtil.getProperty(layer, getProperty());
				return new AnimatableEnumElementDelegate<OrderOfFillAndStroke>(this, name, avalue) {

					@Override
					protected Menu createMenu() {
						Menu menu = super.createMenu();

						boolean perCharacter3D = LayerNature.isThreeD(layer) && ((TextLayer) layer).isPerCharacter3D();
						if (perCharacter3D) {
							for (MenuItem item : menu.getItems()) {
								Object data = item.getData();
								if (data instanceof OrderOfFillAndStroke) {
									switch ((OrderOfFillAndStroke) data) {
										case ALL_STROKES_OVER_ALL_FILLS:
										case ALL_FILLS_OVER_ALL_STROKES:
											item.setEnabled(false);
											break;
									}
								}
							}
						}

						return menu;
					}
				};
			}
		});
	}

}
