/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.Project;

public class ModifyMediaOptionsOperation extends ProjectOperation {

	private final String itemId;

	private final MediaOptions oldOptions;

	private final MediaOptions newOptions;


	public ModifyMediaOptionsOperation(ProjectManager pm, MediaItem mediaItem, MediaOptions newOptions) {
		super(pm, "メディアオプションの変更", true);
		pm.checkItem(mediaItem);

		itemId = mediaItem.getId();

		// TODO エンコードして保持した方がいいかも？
		this.oldOptions = mediaItem.getMediaOptions();
		this.newOptions = newOptions.clone();
	}

	@Override
	protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		setOptions(project, pm, newOptions);
		return Status.OK_STATUS;
	}

	@Override
	protected IStatus undo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		setOptions(project, pm, oldOptions);
		return Status.OK_STATUS;
	}

	private void setOptions(Project project, ProjectManager pm, MediaOptions options) {
		MediaItem mediaItem = project.getItem(itemId);
		mediaItem.setMediaOptions(options);

		if (pm != null) {
			pm.fireItemUpdate(mediaItem);
		}
	}

	public String getMediaItemId() {
		return itemId;
	}

}
