/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import java.util.List;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;

public class AddExpressionsOperation extends ProjectOperationCollection {

	private final String _compId;

	public AddExpressionsOperation(ProjectManager projectManager, LayerComposition comp) {
		super(projectManager, "エクスプレッションの追加");
		projectManager.checkComposition(comp);
		_compId = comp.getId();
	}

	public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		IStatus status = super.execute(monitor, info);
		if (status.isOK()) {
			fireExpressionsAddRemove(true);
		}
		return status;
	}

	public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		IStatus status = super.redo(monitor, info);
		if (status.isOK()) {
			fireExpressionsAddRemove(true);
		}
		return status;
	}

	public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		IStatus status = super.undo(monitor, info);
		if (status.isOK()) {
			fireExpressionsAddRemove(false);
		}
		return status;
	}

	private Object[][] createData(LayerComposition comp) {
		List<Object[]> data = Util.newList();

		for (ProjectOperation op : list) {
			if (op instanceof ModifyLayerExpressionOperation) {
				ModifyLayerExpressionOperation modifyOp = (ModifyLayerExpressionOperation) op;
				data.add(new Object[] { comp.getLayer(modifyOp.getLayerId()), modifyOp.getProperty() });
			} else if (op instanceof ModifyEffectExpressionOperation) {
				ModifyEffectExpressionOperation modifyOp = (ModifyEffectExpressionOperation) op;
				data.add(new Object[] { comp.getLayer(modifyOp.getLayerId()), modifyOp.getEffectIndex(), modifyOp.getProperty() });
			}
		}

		return data.toArray(new Object[data.size()][]);
	}

	private void fireExpressionsAddRemove(boolean add) {
		LayerComposition comp = projectManager.getProject().getComposition(_compId);
		Object[][] data = createData(comp);

		if (add) {
			projectManager.fireExpressionsAdd(comp, data);
		} else {
			projectManager.fireExpressionsRemove(comp, data);
		}
	}

}
