/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.Perspective;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.ProjectView;

public class NewProjectAction extends Action {

	private final IWorkbenchWindow window;

	public NewProjectAction(IWorkbenchWindow window) {
		super("新規プロジェクト");
		this.window = window;

		setId(CommandIds.NEW_PROJECT);
		setActionDefinitionId(CommandIds.NEW_PROJECT);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/new_project.png"));
	}

	public void run() {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		if (pm != null) {
			switch (SaveUtil.saveIfDirty(pm)) {
				case NOT_DIRTY:
				case SAVED:
				case UNSAVED:
					break;
				default:
					return;
			}

			pm.dispose();
			pm = null;
		}

		newProject(window);
	}

	public static ProjectManager newProject(IWorkbenchWindow window) {
		Perspective.reset(window);

		ProjectManager pm = ProjectManager.newProject(window);

		UIUtil.showView(window.getActivePage(), ProjectView.ID);
		UIUtil.showView(window.getActivePage(), "org.eclipse.ui.console.ConsoleView", null, IWorkbenchPage.VIEW_CREATE);
		return pm;
	}

}
