/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

import org.eclipse.ui.splash.AbstractSplashHandler;

import ch.kuramo.javie.core.JavieRuntimeException;

public class SplashEnhancement {

	public static void patch() {
		try {
			ClassLoader loader = AbstractSplashHandler.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));

			CtClass targetClass = pool.get("org.eclipse.ui.splash.BasicSplashHandler$AbsolutePositionProgressMonitorPart");
			targetClass.addField(new CtField(CtClass.intType, "beginTaskCount", targetClass), "0");

			CtMethod targetMethod = targetClass.getDeclaredMethod("beginTask");
			targetMethod.insertBefore("if (++beginTaskCount == 2) return;");

			targetClass.toClass(loader, null);

		} catch (NotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (CannotCompileException e) {
			throw new JavieRuntimeException(e);
		}
	}

}
