/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.DefaultGraphicsDevice;
import javax.media.nativewindow.NativeWindowFactory;

public class AWTGraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    private GraphicsDevice device;
    private String subType;

    protected AWTGraphicsDevice(GraphicsDevice graphicsDevice, int n) {
        super("AWT", graphicsDevice.getIDstring(), n);
        this.device = graphicsDevice;
        this.subType = null;
    }

    public static AbstractGraphicsDevice createDevice(GraphicsDevice graphicsDevice, int n) {
        if (null == graphicsDevice) {
            graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            n = 0;
        }
        return new AWTGraphicsDevice(graphicsDevice, n);
    }

    public Object clone() {
        return super.clone();
    }

    public GraphicsDevice getGraphicsDevice() {
        return this.device;
    }

    public void setSubType(String string, long l) {
        this.handle = l;
        this.subType = string;
        this.setToolkitLock(NativeWindowFactory.createDefaultToolkitLock(string, l));
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        return this.getClass().toString() + "[type " + this.getType() + "[subType " + this.getSubType() + "], connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", awtDevice " + this.device + ", handle 0x" + Long.toHexString(this.getHandle()) + "]";
    }
}

