/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.wizards.MediaOptionsWizard;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaOptions;

public class MediaOptionsDialogAction extends Action implements ISelectionChangedListener {

	private final IWorkbenchWindow window;

	private MediaItem mediaItem;


	public MediaOptionsDialogAction(IWorkbenchWindow window, Viewer viewer) {
		super("メディアオプション...");
		this.window = window;

		//setId(CommandIds.MEDIA_OPTIONS_DIALOG);
		//setActionDefinitionId(CommandIds.MEDIA_OPTIONS_DIALOG);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/media_options_dialog.png"));

		updateState(viewer.getSelection());
		viewer.addSelectionChangedListener(this);
	}

	private void updateState(ISelection selection) {
		setEnabled(false);
		mediaItem = null;

		Object obj = null;

		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			if (structuredSelection.size() == 1) {
				obj = structuredSelection.getFirstElement();
			}
		}

		if (obj instanceof MediaItem) {
			MediaItem mi = (MediaItem) obj;
			MediaOptions options = mi.getMediaOptions();
			if (options != null && options.isAvailable()) {
				setEnabled(true);
				mediaItem = mi;
			}
		}
	}

	public void selectionChanged(SelectionChangedEvent event) {
		updateState(event.getSelection());
	}

	public void run() {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		if (pm != null && mediaItem != null) {
			MediaOptionsWizard wizard = new MediaOptionsWizard(pm, mediaItem);
			WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
			dialog.open();
		}
	}

}
