/*
 * Copyright (c) 2009-2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.io.File;

import org.eclipse.swt.widgets.FileDialog;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.output.JavaImageSequenceOutput;
import ch.kuramo.javie.core.output.Output.VideoChannels;

import com.google.inject.Injector;

public class SequenceOutputAction extends AbstractOutputAction<JavaImageSequenceOutput> {

	public SequenceOutputAction(LayerCompositionView view) {
		super("イメージシーケンス...", view);
		setId(CommandIds.SEQUENCE_OUTPUT);
		setActionDefinitionId(CommandIds.SEQUENCE_OUTPUT);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/sequence_output.png"));
	}

	@Override
	protected String getDefaultExtension() {
		return null;
	}

	@Override
	protected JavaImageSequenceOutput createOutput(Injector injector) {
		JavaImageSequenceOutput output = injector.getInstance(JavaImageSequenceOutput.class);
		output.setVideoChannels(VideoChannels.RGBA_STRAIGHT);
		return output;
	}

	@Override
	protected FileDialog createFileDialog(File folder, String fileName) {
		FileDialog dialog = super.createFileDialog(folder, fileName);
		dialog.setOverwrite(false);		// ファイルダイアログで指定するのは連番ファイルのプレフィックスなので、上書きの警告を出しても無意味。
		return dialog;
	}

	@Override
	protected String getSubTaskText(int currentWork, int totalWork) {
		return String.format("フレーム: %d/%d", currentWork, totalWork);
	}

}
