/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.wizard.Wizard;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.wizards.AVIOutputWizard;
import ch.kuramo.javie.core.output.WindowsDirectShowOutput;

import com.google.inject.Injector;

public class AVIOutputAction extends AbstractOutputAction<WindowsDirectShowOutput> {

	public AVIOutputAction(LayerCompositionView view) {
		super("AVI...", view);
		setId(CommandIds.AVI_OUTPUT);
		setActionDefinitionId(CommandIds.AVI_OUTPUT);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/avi_output.png"));
	}

	@Override
	protected String getDefaultExtension() {
		return ".avi";
	}

	@Override
	protected WindowsDirectShowOutput createOutput(Injector injector) {
		return injector.getInstance(WindowsDirectShowOutput.class);
	}

	@Override
	protected Wizard createWizard(WindowsDirectShowOutput output) {
		return new AVIOutputWizard(getComposition(), output);
	}

}
