package ch.kuramo.javie.core.datatypes;

import static org.testng.Assert.assertEquals;

import java.lang.reflect.Field;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TimeTest {

	@DataProvider(name="valueAndScales")
	public Object[][] valueAndScales() {
		return new Object[][] {
				{        166833L,          10000000 },
				{       -166833L,          10000000 },
				{             1L,              1234 },
				{    1234567890L,          99999999 },
				{ Long.MAX_VALUE,          98765432 },
				{        100000L, Integer.MAX_VALUE }
		};
	}

	@Test(dataProvider="valueAndScales")
	public void testPublicFields(long value, int scale) {
		Time time = new Time(value, scale);
		assertEquals(time.timeValue, value);
		assertEquals(time.timeScale, scale);
	}

	@Test(dataProvider="valueAndScales")
	public void testGetters(long value, int scale) {
		Time time = new Time(value, scale);
		assertEquals(time.getTimeValue(), value);
		assertEquals(time.getTimeScale(), scale);
	}


	@DataProvider(name="fieldNames")
	public Object[][] fieldNames() {
		return new Object[][] { { "timeValue" }, { "timeScale" } };
	}

	@Test(dataProvider="fieldNames", expectedExceptions={ IllegalAccessException.class })
	public void verifyFinalFieldAccess(String fieldName)
			throws SecurityException, NoSuchFieldException,
			IllegalArgumentException, IllegalAccessException {

		Field f = Time.class.getField(fieldName);
		f.set(new Time(1000, 100000), 1234);
	}

	@DataProvider(name="fieldTypes")
	public Object[][] fieldTypes() {
		return new Object[][] {
				{ "timeValue", long.class },
				{ "timeScale", int.class }
		};
	}

	@Test(dataProvider="fieldTypes")
	public void verifyFieldTypes(String fieldName, Class<?> fieldType)
			throws SecurityException, NoSuchFieldException {

		Field f = Time.class.getField(fieldName);
		assertEquals(f.getType(), fieldType);
	}

	@DataProvider(name="compareData")
	public Object[][] compareData() {
		return new Object[][] {											// before, after, compareTo, equals
				{ new Time(166833L, 10000000), new Time(333666L, 10000000),  true, false,        -1, false },
				{ new Time(166833L, 10000000), new Time(166833L, 10000000), false, false,         0,  true },
				{ new Time(166834L, 10000000), new Time(166833L, 10000000), false,  true,         1, false },
				{ new Time(166833L, 10000000), new Time(166833L, 20000000), false,  true,         1, false },
				{ new Time(166833L, 10000000), new Time(166833L,  5000000),  true, false,        -1, false },
				{ new Time(111111L,  3333333), new Time(333333L,  9999999), false, false,         0,  true },
				// TODO もっとテストデータを増やす
		};
	}

	@Test(dataProvider="compareData")
	public void testCompareMethods(Time t1, Time t2, boolean before, boolean after, int compareTo, boolean equals) {
		assertEquals(t1.before(t2), before);
		assertEquals(t2.before(t1), after);

		assertEquals(t1.after(t2), after);
		assertEquals(t2.after(t1), before);

		assertEquals(t1.compareTo(t2), compareTo);
		assertEquals(t2.compareTo(t1), -compareTo);

		assertEquals(t1.equals(t2), equals);
		assertEquals(t2.equals(t1), equals);
	}

	// TODO hashCode, toSecond, fromFrameNumber, toFrameNumber のテスト

}
