/*
 * Copyright (c) 2009-2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Time;

public abstract class AbstractLayer implements Layer {

	private String _id;

	private String _parentId;

	private String _name = "名称未設定レイヤー";

	private boolean _shy;

	private Time _startTime;

	private Time _inPoint;

	private Time _outPoint;

	private double _rate = 1.0;


	public AbstractLayer() {
		super();
	}

	public void initialize() {
		_id = Util.randomId();
	}

	public String getId() {
		return _id;
	}

	public void setId(String id) {
		_id = id;
	}

	public String getParentId() {
		return _parentId;
	}

	public void setParentId(String parentId) {
		_parentId = parentId;
	}

	public String getName() {
		return _name;
	}

	public void setName(String name) {
		_name = name;
	}

	public boolean isShy() {
		return _shy;
	}

	public void setShy(boolean shy) {
		_shy = shy;
	}

	public Time getStartTime() {
		return _startTime;
	}

	public void setStartTime(Time startTime) {
		_startTime = startTime;
	}

	public Time getInPoint() {
		return _inPoint;
	}

	public void setInPoint(Time inPoint) {
		_inPoint = inPoint;
	}

	public Time getOutPoint() {
		return _outPoint;
	}

	public void setOutPoint(Time outPoint) {
		_outPoint = outPoint;
	}

	public double getRate() {
		return _rate;
	}

	public void setRate(double rate) {
		_rate = rate;
	}

	public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
		// nothing to do
	}

	public void prepareExpression(ExpressionScope scope) {
		final int prime = 31;
		int seed = 1;
		seed = prime * seed + getId().hashCode();
		seed = prime * seed + getName().hashCode();
		seed = prime * seed + getStartTime().hashCode();
		seed = prime * seed + getInPoint().hashCode();
		seed = prime * seed + getOutPoint().hashCode();

		scope.setThis(this);
		scope.setRandomSeed(seed);
	}

	public class LayerExpressionElement {

		protected final CoreContext context;

		public LayerExpressionElement(CoreContext context) {
			this.context = context;
		}

		protected <T> T elem(Expressionee exprnee) {
			return context.getExpressionElement(exprnee);
		}

		public LayerExpressionElement getThisLayer() {
			return this;
		}

		public double getStartTime()	{ return _startTime.toSecond(); }
		public double getInPoint()		{ return _inPoint.toSecond(); }
		public double getOutPoint()		{ return _outPoint.toSecond(); }
		public double getRate()			{ return _rate; }

		@Override
		public String toString() {
			return _id;
		}
	}

}
