/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.CastsShadows;
import ch.kuramo.javie.core.MediaLayer;

public class MaterialOptionsElement extends Element {

	private Element[] children;


	public MaterialOptionsElement(LayerElement parent) {
		super(parent);
	}

	public String getColumnText(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.NAME_COL:
				return "マテリアルオプション";

			default:
				return null;
		}
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		if (children == null) {
			MediaLayer layer = getLayer();
			children = new Element[] {
					LayerEnumPropertyElement.<CastsShadows>forSimpleProperty(this, layer, "castsShadows", "シャドウを落とす"),
					new ShadowExpansionElement(),
					LayerAnimatableValueElement.forSimpleProperty(this, layer, "lightTransmission", "ライト透過", "%"),
					LayerBooleanPropertyElement.forSimpleProperty(this, layer, "acceptsShadows", "シャドウを受ける"),
					LayerBooleanPropertyElement.forSimpleProperty(this, layer, "acceptsLights", "ライトを受ける"),
					LayerAnimatableValueElement.forSimpleProperty(this, layer, "ambient", "アンビエント", "%"),
					LayerAnimatableValueElement.forSimpleProperty(this, layer, "diffuse", "拡散", "%"),
					LayerAnimatableValueElement.forSimpleProperty(this, layer, "specular", "鏡面", "%"),
					LayerAnimatableValueElement.forSimpleProperty(this, layer, "shininess", "光沢", "%"),
					LayerAnimatableValueElement.forSimpleProperty(this, layer, "metal", "金属", "%")
			};
		}
		return children;
	}

	private MediaLayer getLayer() {
		return (MediaLayer) ((LayerElement) parent).layer;
	}

	private class ShadowExpansionElement extends Element {

		private Element[] children;

		private ShadowExpansionElement() {
			super(MaterialOptionsElement.this);
		}

		public String getColumnText(int columnIndex) {
			switch (columnIndex) {
				case LayerCompositionView.NAME_COL:
					return "シャドウの範囲を拡張";

				default:
					return null;
			}
		}

		public boolean hasChildren() {
			return true;
		}

		public Element[] getChildren() {
			if (children == null) {
				MediaLayer layer = getLayer();
				children = new Element[] {
						LayerAnimatableValueElement.forSimpleProperty(this, layer, "shadowExpansionLeft", "左"),
						LayerAnimatableValueElement.forSimpleProperty(this, layer, "shadowExpansionTop", "上"),
						LayerAnimatableValueElement.forSimpleProperty(this, layer, "shadowExpansionRight", "右"),
						LayerAnimatableValueElement.forSimpleProperty(this, layer, "shadowExpansionBottom", "下")
				};
			}
			return children;
		}

	}

}
