/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AnimatableLayerReference;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;

public class AnimatableLayerReferenceElementDelegate extends AnimatableValueElementDelegate<String> {

	public AnimatableLayerReferenceElementDelegate(
			AnimatableValueElement element, String name, AnimatableLayerReference avalue) {

		super(element, name, avalue);
	}

	protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
		drawValue(gc, x, y, height, focused, getName(getLayerComposition().getLayer(valueToDraw)));
	}

	protected boolean canDragGestureEdit() {
		return false;
	}

	protected String dragGesture(double dx, double dy) {
		throw new UnsupportedOperationException("drag gesture edit is not supported");
	}

	protected boolean isInPlaceEditorActive() {
		// FIXME メニューが表示されているときは true を返すべき。
		return false;
	}

	protected void openInPlaceEditor() {
		Rectangle r = valueArea.get(valueIndex);
		Menu menu = element.createPopUpMenu(r.x-5, r.y+r.height+2);

		final Layer currentLayer = getLayerComposition().getLayer(valueWithoutExpr);

		Action action = new Action(getName(null), IAction.AS_RADIO_BUTTON) {
			public void run() {
				if (currentLayer != null) {
					modifyValue("");
				}
			}
		};
		action.setChecked(currentLayer == null);
		new ActionContributionItem(action).fill(menu, -1);

		new MenuItem(menu, SWT.SEPARATOR);

		for (final Layer layer : getLayerComposition().getLayers()) {
			action = new Action(getName(layer).replaceAll("&", "&&"), IAction.AS_RADIO_BUTTON) {
				public void run() {
					if (currentLayer != layer) {
						modifyValue(layer.getId());
					}
				}
			};
			action.setChecked(currentLayer == layer);
			new ActionContributionItem(action).fill(menu, 2);
		}

		menu.setVisible(true);
	}

	private LayerComposition getLayerComposition() {
		return (LayerComposition) element.viewer.getData(LayerCompositionView.LAYER_COMPOSITION);
	}

	private boolean isLayerNameMode() {
		return Boolean.TRUE.equals(element.viewer.getData(LayerCompositionView.LAYER_NAME_MODE));
	}

	private String getName(Layer layer) {
		if (layer == null) {
			return "なし";
		} else if (!(layer instanceof ItemLayer<?>) || isLayerNameMode()) {
			return layer.getName();
		} else {
			return ((ItemLayer<?>) layer).getItem().getName();
		}
	}

}
